% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{summary.bayesTest}
\alias{summary.bayesTest}
\title{Summarize bayesTest objects}
\usage{
\method{summary}{bayesTest}(object, percentLift = rep(0,
  length(object$posteriors)), credInt = rep(0.9, length(object$posteriors)),
  ...)
}
\arguments{
\item{object}{an object of class "bayesTest"}

\item{percentLift}{a vector of length(x$posteriors). Each entry corresponds to the percent lift ((A - B) / B) to summarize for for
the respective posterior in x. Note this is on a 'point' scale. percentLift = 5 implies you want to test for a 5\% lift.}

\item{credInt}{a vector of length(x$posteriors). Each entry corresponds to the width of credible interval of (A - B) / B to calculate for
the respective posterior in x. Also on a 'point' scale.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A \code{summaryBayesTest} object which contains summaries of the Posterior distributions, direct probablities that A > B (by
\code{percentLift}), credible intervals on (A - B) / B, and the Posterior Expected Loss on all estimated parameters.
}
\description{
Summary method for objects of class "bayesTest".
}
\note{
The Posterior Expected Loss (https://en.wikipedia.org/wiki/Bayes_estimator) is a good indicator of when to end a Bayesian
AB test. If the PEL is lower than the absolute delta of the minimum effect you wish to detect, the test can be reasonably be stopped.
}
\examples{
A_pois <- rpois(100, 5)
B_pois <- rpois(100, 4.7)

AB1 <- bayesTest(A_pois, B_pois, priors = c('shape' = 25, 'rate' = 5), distribution = 'poisson')

summary(AB1)
summary(AB1, percentLift = 10, credInt = .95)

}

