# bayesImageS 0.5-3

* modified vignette swNoData to only use PottsUtils conditionally
* deleted vignette PFAB due to problems with Stan and Boost on `gannet/ripley/tests-ATLAS`

# bayesImageS 0.5-2

* changed maintainer email address due to new academic affiliation
* reorganised package vignettes
* NAMESPACE is now generated by roxygen2
* added LICENSE file for GPL 2

# bayesImageS 0.5-1

* new vignette introducing the parametric functional approximate Bayesian (PFAB) algorithm
* removed all @seealso from Roxygen docs due to CRAN WARNings because PottsUtils has now been permanently removed from the CRAN repository

# bayesImageS 0.5-0

## New features

* improvements to Bayesian indirect likelihood (BIL) algorithm (`mh$alg="aux"`):
    + MH hyperparameter `Ecrit` for 2nd order phase transition when k > 4
    + MH hyperparameter `factor` to inflate the variance of the surrogate model
    + separate MH hyperparameters `Vmax1`,`Vmax2` for $\beta < \beta_{crit}$ and $\beta > \beta_{crit}$, respectively

* option `mh$sort` to impose an ordering constraint on the component means

## Bug fixes

* removed OpenMP options from `Makevars` to fix problems with RcppArmadillo. Users should edit `~/.R/Makevars` to enabel multithreading.

* no longer wait for `mh$auxiliary` iterations before beginning to update $\beta$ using the exchange algorithm or ABC. For $\beta > \beta_{crit}$, this increased the propensity of the Gibbs sampler to become stuck in a suboptimal local mode, far from the true parameter value.

* added `jss.bst` and `jss.cls` to `.Rbuildignore`

# bayesImageS 0.4-1

* removed the deprecated `slices` parameter from `mcmcPotts()`

* some minor edits to the `Roxygen` documentation

* added ORCID to DESCRIPTION

* removed the R package `PottsUtils` from Suggested packages; added `mcmcse`

* moved `README-chunkname.png` images from root directory to `inst/images`

# bayesImageS 0.4-0

## New features

* Functions getNeighbors(), getEdges(), getBlocks() contributed by Dai Feng. These are currently exact copies of the equivalent functions in the R package PottsUtils. The reason for duplicating this code is to avoid picking up dependencies on miscF, R2jags, BRugs, etc.
    + <https://cran.r-project.org/package=PottsUtils>

* Added new option to swNoData and mcmcPottsNoData to initialise the labels using either random or deterministic values. This can be useful when comparing the convergence of the Swendsen-Wang and Gibbs sampling algorithms to known distributions (e.g. when $\beta$=0 or $\infty$)

* Additional documentation in README.md with an example of usage

## Bug fixes

* Fixed compile errors on SPARC Solaris
    + <https://www.r-project.org/nosvn/R.check/r-patched-solaris-x86/bayesImageS-00check.html>

* Fixed compile warnings from icpc (Intel Parallel Studio XE) on Linux

* Added bayesImageS_init.cpp to call R_registerRoutines and R_useDynamicSymbols

# bayesImageS 0.3-3

* First version released on CRAN

# bayesImageS 0.1-21

* First public release on RunMyCode.org:
    + <http://www.runmycode.org/companion/view/546>
