% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariate_importance-class.R
\name{covariates_importance-class}
\alias{covariates_importance-class}
\alias{print.covariates_importance}
\alias{plot.covariates_importance}
\alias{barplot.covariates_importance}
\alias{boxplot.covariates_importance}
\title{Class for covariates importance matrices}
\usage{
\method{print}{covariates_importance}(x, component = "intensity", ...)

\method{plot}{covariates_importance}(
  x,
  component = "intensity",
  y = "importance",
  quantiles = c(0.025, 0.5, 0.975),
  ...
)

\method{barplot}{covariates_importance}(height, component = "intensity", y, ...)

\method{boxplot}{covariates_importance}(x, component = "intensity", ...)
}
\arguments{
\item{x}{The \code{covariates_importance} object.}

\item{component}{Either \code{"intensity"}, \code{"observability"} or
\code{"both"}.}

\item{...}{Other parameters passed to \code{\link[graphics]{boxplot}}.}

\item{y}{Either \code{"interval"} or \code{"density"}. The formal gives
vertical credible intervals, and the latter gives separate density plots
with the specified quantiles as vertical lines.}

\item{quantiles}{A 2- or 3-simensional vector with the desired quantiles
specified. If 3-dimensiona, the middle point is drawn as a dot when the
\code{y} parameter is set as \code{"interval"}.}

\item{height}{The \code{covariates_importance} object.}
}
\value{
The invisible object.

Nothing is returned. Plot is called and drawn on the configured
device.

A barplot. See \code{barplot} for details. If component is selected
as \code{"both"}, only the second barplot is returned.

A boxplot. See \code{boxplot} for details. If component is selected
as \code{"both"}, only the second boxplot is returned.
}
\description{
Objects of this class is the output of the "covariates_importance" object
from the \code{\link{bayesPO_fit-class}}. It can be plotted which uses
the \code{\link[graphics]{graphics}} package. The \code{print} method
gives a point-wise estimation, the same seen in the \code{bacplot} method.
Both \code{plot} and \code{boxplot} methods use the posterior distribution
of the importance.
}
\details{
Objects of this class have two matrices where the Monte Carlo samples on the
rows and parameters on the columns. One matrix is for the intensity
importance and the other for the observability importance.
}
\seealso{
\code{\link[graphics]{barplot}}.

\code{\link[graphics]{boxplot}}.
}
