// Generated by rstantools.  Do not edit by hand.

/*
    path is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    path is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with path.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_hmm_gaussian_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_hmm_gaussian");
    reader.add_event(180, 178, "end", "model_hmm_gaussian");
    return reader;
}
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
normalize(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 6;
        return stan::math::promote_scalar<fun_return_scalar_t__>(divide(x, sum(x)));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct normalize_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x, std::ostream* pstream__) const {
        return normalize(x, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_hmm_gaussian
  : public stan::model::model_base_crtp<model_hmm_gaussian> {
private:
        int T;
        int K;
        std::vector<double> x_t;
        int est_sigma;
        std::vector<double> sigma_t;
public:
    model_hmm_gaussian(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_hmm_gaussian(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_hmm_gaussian_namespace::model_hmm_gaussian";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            check_greater_or_equal(function__, "T", T, 1);
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 1);
            current_statement_begin__ = 13;
            validate_non_negative_index("x_t", "T", T);
            context__.validate_dims("data initialization", "x_t", "double", context__.to_vec(T));
            x_t = std::vector<double>(T, double(0));
            vals_r__ = context__.vals_r("x_t");
            pos__ = 0;
            size_t x_t_k_0_max__ = T;
            for (size_t k_0__ = 0; k_0__ < x_t_k_0_max__; ++k_0__) {
                x_t[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 14;
            context__.validate_dims("data initialization", "est_sigma", "int", context__.to_vec());
            est_sigma = int(0);
            vals_i__ = context__.vals_i("est_sigma");
            pos__ = 0;
            est_sigma = vals_i__[pos__++];
            check_greater_or_equal(function__, "est_sigma", est_sigma, 0);
            current_statement_begin__ = 15;
            validate_non_negative_index("sigma_t", "T", T);
            context__.validate_dims("data initialization", "sigma_t", "double", context__.to_vec(T));
            sigma_t = std::vector<double>(T, double(0));
            vals_r__ = context__.vals_r("sigma_t");
            pos__ = 0;
            size_t sigma_t_k_0_max__ = T;
            for (size_t k_0__ = 0; k_0__ < sigma_t_k_0_max__; ++k_0__) {
                sigma_t[k_0__] = vals_r__[pos__++];
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 20;
            validate_non_negative_index("p_1k", "K", K);
            num_params_r__ += (K - 1);
            current_statement_begin__ = 21;
            validate_non_negative_index("A_ij", "K", K);
            validate_non_negative_index("A_ij", "K", K);
            num_params_r__ += ((K - 1) * K);
            current_statement_begin__ = 24;
            validate_non_negative_index("mu_k", "K", K);
            num_params_r__ += K;
            current_statement_begin__ = 25;
            validate_non_negative_index("sigma_k", "K", K);
            num_params_r__ += (1 * K);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_hmm_gaussian() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 20;
        if (!(context__.contains_r("p_1k")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable p_1k missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("p_1k");
        pos__ = 0U;
        validate_non_negative_index("p_1k", "K", K);
        context__.validate_dims("parameter initialization", "p_1k", "vector_d", context__.to_vec(K));
        Eigen::Matrix<double, Eigen::Dynamic, 1> p_1k(K);
        size_t p_1k_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < p_1k_j_1_max__; ++j_1__) {
            p_1k(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.simplex_unconstrain(p_1k);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable p_1k: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 21;
        if (!(context__.contains_r("A_ij")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable A_ij missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("A_ij");
        pos__ = 0U;
        validate_non_negative_index("A_ij", "K", K);
        validate_non_negative_index("A_ij", "K", K);
        context__.validate_dims("parameter initialization", "A_ij", "vector_d", context__.to_vec(K,K));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > A_ij(K, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
        size_t A_ij_j_1_max__ = K;
        size_t A_ij_k_0_max__ = K;
        for (size_t j_1__ = 0; j_1__ < A_ij_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_ij_k_0_max__; ++k_0__) {
                A_ij[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t A_ij_i_0_max__ = K;
        for (size_t i_0__ = 0; i_0__ < A_ij_i_0_max__; ++i_0__) {
            try {
                writer__.simplex_unconstrain(A_ij[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable A_ij: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 24;
        if (!(context__.contains_r("mu_k")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_k missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_k");
        pos__ = 0U;
        validate_non_negative_index("mu_k", "K", K);
        context__.validate_dims("parameter initialization", "mu_k", "vector_d", context__.to_vec(K));
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu_k(K);
        size_t mu_k_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < mu_k_j_1_max__; ++j_1__) {
            mu_k(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.ordered_unconstrain(mu_k);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_k: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 25;
        if (!(context__.contains_r("sigma_k")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_k missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_k");
        pos__ = 0U;
        validate_non_negative_index("sigma_k", "K", K);
        context__.validate_dims("parameter initialization", "sigma_k", "double", context__.to_vec(K));
        std::vector<double> sigma_k(K, double(0));
        size_t sigma_k_k_0_max__ = K;
        for (size_t k_0__ = 0; k_0__ < sigma_k_k_0_max__; ++k_0__) {
            sigma_k[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_k_i_0_max__ = K;
        for (size_t i_0__ = 0; i_0__ < sigma_k_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma_k[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_k: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 20;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> p_1k;
            (void) p_1k;  // dummy to suppress unused var warning
            if (jacobian__)
                p_1k = in__.simplex_constrain(K, lp__);
            else
                p_1k = in__.simplex_constrain(K);
            current_statement_begin__ = 21;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > A_ij;
            size_t A_ij_d_0_max__ = K;
            A_ij.reserve(A_ij_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < A_ij_d_0_max__; ++d_0__) {
                if (jacobian__)
                    A_ij.push_back(in__.simplex_constrain(K, lp__));
                else
                    A_ij.push_back(in__.simplex_constrain(K));
            }
            current_statement_begin__ = 24;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu_k;
            (void) mu_k;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_k = in__.ordered_constrain(K, lp__);
            else
                mu_k = in__.ordered_constrain(K);
            current_statement_begin__ = 25;
            std::vector<local_scalar_t__> sigma_k;
            size_t sigma_k_d_0_max__ = K;
            sigma_k.reserve(sigma_k_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_k_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma_k.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma_k.push_back(in__.scalar_lb_constrain(0));
            }
            // transformed parameters
            current_statement_begin__ = 29;
            validate_non_negative_index("unalpha_tk", "K", K);
            validate_non_negative_index("unalpha_tk", "T", T);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > unalpha_tk(T, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(K));
            stan::math::initialize(unalpha_tk, DUMMY_VAR__);
            stan::math::fill(unalpha_tk, DUMMY_VAR__);
            // transformed parameters block statements
            {
            current_statement_begin__ = 32;
            validate_non_negative_index("accumulator", "K", K);
            std::vector<local_scalar_t__  > accumulator(K, local_scalar_t__(DUMMY_VAR__));
            stan::math::initialize(accumulator, DUMMY_VAR__);
            stan::math::fill(accumulator, DUMMY_VAR__);
            current_statement_begin__ = 34;
            if (as_bool(logical_eq(est_sigma, 1))) {
                current_statement_begin__ = 36;
                stan::model::assign(unalpha_tk, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            add(stan::math::log(p_1k), normal_log(get_base1(x_t, 1, "x_t", 1), mu_k, sigma_k)), 
                            "assigning variable unalpha_tk");
            } else {
                current_statement_begin__ = 39;
                stan::model::assign(unalpha_tk, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            add(stan::math::log(p_1k), normal_log(get_base1(x_t, 1, "x_t", 1), mu_k, get_base1(sigma_t, 1, "sigma_t", 1))), 
                            "assigning variable unalpha_tk");
            }
            current_statement_begin__ = 42;
            for (int t = 2; t <= T; ++t) {
                current_statement_begin__ = 43;
                for (int j = 1; j <= K; ++j) {
                    current_statement_begin__ = 44;
                    for (int i = 1; i <= K; ++i) {
                        current_statement_begin__ = 47;
                        if (as_bool(logical_eq(est_sigma, 1))) {
                            current_statement_begin__ = 49;
                            stan::model::assign(accumulator, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        ((get_base1(get_base1(unalpha_tk, (t - 1), "unalpha_tk", 1), i, "unalpha_tk", 2) + stan::math::log(get_base1(get_base1(A_ij, i, "A_ij", 1), j, "A_ij", 2))) + normal_log(get_base1(x_t, t, "x_t", 1), get_base1(mu_k, j, "mu_k", 1), get_base1(sigma_k, j, "sigma_k", 1))), 
                                        "assigning variable accumulator");
                        } else {
                            current_statement_begin__ = 52;
                            stan::model::assign(accumulator, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        ((get_base1(get_base1(unalpha_tk, (t - 1), "unalpha_tk", 1), i, "unalpha_tk", 2) + stan::math::log(get_base1(get_base1(A_ij, i, "A_ij", 1), j, "A_ij", 2))) + normal_log(get_base1(x_t, t, "x_t", 1), get_base1(mu_k, j, "mu_k", 1), get_base1(sigma_t, t, "sigma_t", 1))), 
                                        "assigning variable accumulator");
                        }
                    }
                    current_statement_begin__ = 56;
                    stan::model::assign(unalpha_tk, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                log_sum_exp(accumulator), 
                                "assigning variable unalpha_tk");
                }
            }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 29;
            size_t unalpha_tk_k_0_max__ = T;
            size_t unalpha_tk_j_1_max__ = K;
            for (size_t k_0__ = 0; k_0__ < unalpha_tk_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < unalpha_tk_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(unalpha_tk[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: unalpha_tk" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable unalpha_tk: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            current_statement_begin__ = 63;
            lp_accum__.add(student_t_log<propto__>(sigma_k, 3, 0, 1));
            current_statement_begin__ = 64;
            lp_accum__.add(student_t_log<propto__>(mu_k, 3, 0, 3));
            current_statement_begin__ = 65;
            lp_accum__.add(log_sum_exp(get_base1(unalpha_tk, T, "unalpha_tk", 1)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("p_1k");
        names__.push_back("A_ij");
        names__.push_back("mu_k");
        names__.push_back("sigma_k");
        names__.push_back("unalpha_tk");
        names__.push_back("unbeta_tk");
        names__.push_back("ungamma_tk");
        names__.push_back("alpha_tk");
        names__.push_back("beta_tk");
        names__.push_back("gamma_tk");
        names__.push_back("log_lik");
        names__.push_back("zstar_t");
        names__.push_back("logp_zstar_t");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_hmm_gaussian_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> p_1k = in__.simplex_constrain(K);
        size_t p_1k_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < p_1k_j_1_max__; ++j_1__) {
            vars__.push_back(p_1k(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > A_ij;
        size_t A_ij_d_0_max__ = K;
        A_ij.reserve(A_ij_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < A_ij_d_0_max__; ++d_0__) {
            A_ij.push_back(in__.simplex_constrain(K));
        }
        size_t A_ij_j_1_max__ = K;
        size_t A_ij_k_0_max__ = K;
        for (size_t j_1__ = 0; j_1__ < A_ij_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_ij_k_0_max__; ++k_0__) {
                vars__.push_back(A_ij[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu_k = in__.ordered_constrain(K);
        size_t mu_k_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < mu_k_j_1_max__; ++j_1__) {
            vars__.push_back(mu_k(j_1__));
        }
        std::vector<double> sigma_k;
        size_t sigma_k_d_0_max__ = K;
        sigma_k.reserve(sigma_k_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_k_d_0_max__; ++d_0__) {
            sigma_k.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_k_k_0_max__ = K;
        for (size_t k_0__ = 0; k_0__ < sigma_k_k_0_max__; ++k_0__) {
            vars__.push_back(sigma_k[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 29;
            validate_non_negative_index("unalpha_tk", "K", K);
            validate_non_negative_index("unalpha_tk", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > unalpha_tk(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
            stan::math::initialize(unalpha_tk, DUMMY_VAR__);
            stan::math::fill(unalpha_tk, DUMMY_VAR__);
            // do transformed parameters statements
            {
            current_statement_begin__ = 32;
            validate_non_negative_index("accumulator", "K", K);
            std::vector<local_scalar_t__  > accumulator(K, local_scalar_t__(DUMMY_VAR__));
            stan::math::initialize(accumulator, DUMMY_VAR__);
            stan::math::fill(accumulator, DUMMY_VAR__);
            current_statement_begin__ = 34;
            if (as_bool(logical_eq(est_sigma, 1))) {
                current_statement_begin__ = 36;
                stan::model::assign(unalpha_tk, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            add(stan::math::log(p_1k), normal_log(get_base1(x_t, 1, "x_t", 1), mu_k, sigma_k)), 
                            "assigning variable unalpha_tk");
            } else {
                current_statement_begin__ = 39;
                stan::model::assign(unalpha_tk, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            add(stan::math::log(p_1k), normal_log(get_base1(x_t, 1, "x_t", 1), mu_k, get_base1(sigma_t, 1, "sigma_t", 1))), 
                            "assigning variable unalpha_tk");
            }
            current_statement_begin__ = 42;
            for (int t = 2; t <= T; ++t) {
                current_statement_begin__ = 43;
                for (int j = 1; j <= K; ++j) {
                    current_statement_begin__ = 44;
                    for (int i = 1; i <= K; ++i) {
                        current_statement_begin__ = 47;
                        if (as_bool(logical_eq(est_sigma, 1))) {
                            current_statement_begin__ = 49;
                            stan::model::assign(accumulator, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        ((get_base1(get_base1(unalpha_tk, (t - 1), "unalpha_tk", 1), i, "unalpha_tk", 2) + stan::math::log(get_base1(get_base1(A_ij, i, "A_ij", 1), j, "A_ij", 2))) + normal_log(get_base1(x_t, t, "x_t", 1), get_base1(mu_k, j, "mu_k", 1), get_base1(sigma_k, j, "sigma_k", 1))), 
                                        "assigning variable accumulator");
                        } else {
                            current_statement_begin__ = 52;
                            stan::model::assign(accumulator, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        ((get_base1(get_base1(unalpha_tk, (t - 1), "unalpha_tk", 1), i, "unalpha_tk", 2) + stan::math::log(get_base1(get_base1(A_ij, i, "A_ij", 1), j, "A_ij", 2))) + normal_log(get_base1(x_t, t, "x_t", 1), get_base1(mu_k, j, "mu_k", 1), get_base1(sigma_t, t, "sigma_t", 1))), 
                                        "assigning variable accumulator");
                        }
                    }
                    current_statement_begin__ = 56;
                    stan::model::assign(unalpha_tk, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                log_sum_exp(accumulator), 
                                "assigning variable unalpha_tk");
                }
            }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t unalpha_tk_j_1_max__ = K;
                size_t unalpha_tk_k_0_max__ = T;
                for (size_t j_1__ = 0; j_1__ < unalpha_tk_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < unalpha_tk_k_0_max__; ++k_0__) {
                        vars__.push_back(unalpha_tk[k_0__](j_1__));
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 69;
            validate_non_negative_index("unbeta_tk", "K", K);
            validate_non_negative_index("unbeta_tk", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > unbeta_tk(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
            stan::math::initialize(unbeta_tk, DUMMY_VAR__);
            stan::math::fill(unbeta_tk, DUMMY_VAR__);
            current_statement_begin__ = 70;
            validate_non_negative_index("ungamma_tk", "K", K);
            validate_non_negative_index("ungamma_tk", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > ungamma_tk(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
            stan::math::initialize(ungamma_tk, DUMMY_VAR__);
            stan::math::fill(ungamma_tk, DUMMY_VAR__);
            current_statement_begin__ = 71;
            validate_non_negative_index("alpha_tk", "K", K);
            validate_non_negative_index("alpha_tk", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > alpha_tk(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
            stan::math::initialize(alpha_tk, DUMMY_VAR__);
            stan::math::fill(alpha_tk, DUMMY_VAR__);
            current_statement_begin__ = 72;
            validate_non_negative_index("beta_tk", "K", K);
            validate_non_negative_index("beta_tk", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > beta_tk(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
            stan::math::initialize(beta_tk, DUMMY_VAR__);
            stan::math::fill(beta_tk, DUMMY_VAR__);
            current_statement_begin__ = 73;
            validate_non_negative_index("gamma_tk", "K", K);
            validate_non_negative_index("gamma_tk", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > gamma_tk(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
            stan::math::initialize(gamma_tk, DUMMY_VAR__);
            stan::math::fill(gamma_tk, DUMMY_VAR__);
            current_statement_begin__ = 74;
            validate_non_negative_index("log_lik", "T", T);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(T);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 75;
            validate_non_negative_index("zstar_t", "T", T);
            std::vector<int> zstar_t(T, int(0));
            stan::math::fill(zstar_t, std::numeric_limits<int>::min());
            current_statement_begin__ = 76;
            double logp_zstar_t;
            (void) logp_zstar_t;  // dummy to suppress unused var warning
            stan::math::initialize(logp_zstar_t, DUMMY_VAR__);
            stan::math::fill(logp_zstar_t, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 79;
            for (int t = 1; t <= T; ++t) {
                current_statement_begin__ = 80;
                stan::model::assign(alpha_tk, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            softmax(get_base1(unalpha_tk, t, "unalpha_tk", 1)), 
                            "assigning variable alpha_tk");
            }
            {
            current_statement_begin__ = 84;
            validate_non_negative_index("accumulator", "K", K);
            std::vector<local_scalar_t__  > accumulator(K, local_scalar_t__(DUMMY_VAR__));
            stan::math::initialize(accumulator, DUMMY_VAR__);
            stan::math::fill(accumulator, DUMMY_VAR__);
            current_statement_begin__ = 86;
            for (int j = 1; j <= K; ++j) {
                current_statement_begin__ = 87;
                stan::model::assign(unbeta_tk, 
                            stan::model::cons_list(stan::model::index_uni(T), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                            1, 
                            "assigning variable unbeta_tk");
            }
            current_statement_begin__ = 89;
            for (int tforward = 0; tforward <= (T - 2); ++tforward) {
                {
                current_statement_begin__ = 90;
                int t(0);
                (void) t;  // dummy to suppress unused var warning
                stan::math::fill(t, std::numeric_limits<int>::min());
                current_statement_begin__ = 91;
                stan::math::assign(t, (T - tforward));
                current_statement_begin__ = 93;
                for (int j = 1; j <= K; ++j) {
                    current_statement_begin__ = 94;
                    for (int i = 1; i <= K; ++i) {
                        current_statement_begin__ = 97;
                        if (as_bool(logical_eq(est_sigma, 1))) {
                            current_statement_begin__ = 98;
                            stan::model::assign(accumulator, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        ((get_base1(get_base1(unbeta_tk, t, "unbeta_tk", 1), i, "unbeta_tk", 2) + stan::math::log(get_base1(get_base1(A_ij, j, "A_ij", 1), i, "A_ij", 2))) + normal_log(get_base1(x_t, t, "x_t", 1), get_base1(mu_k, i, "mu_k", 1), get_base1(sigma_k, i, "sigma_k", 1))), 
                                        "assigning variable accumulator");
                        } else {
                            current_statement_begin__ = 100;
                            stan::model::assign(accumulator, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        ((get_base1(get_base1(unbeta_tk, t, "unbeta_tk", 1), i, "unbeta_tk", 2) + stan::math::log(get_base1(get_base1(A_ij, j, "A_ij", 1), i, "A_ij", 2))) + normal_log(get_base1(x_t, t, "x_t", 1), get_base1(mu_k, i, "mu_k", 1), get_base1(sigma_t, t, "sigma_t", 1))), 
                                        "assigning variable accumulator");
                        }
                    }
                    current_statement_begin__ = 104;
                    stan::model::assign(unbeta_tk, 
                                stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                log_sum_exp(accumulator), 
                                "assigning variable unbeta_tk");
                }
                }
            }
            current_statement_begin__ = 108;
            for (int t = 1; t <= T; ++t) {
                current_statement_begin__ = 109;
                stan::model::assign(beta_tk, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            softmax(get_base1(unbeta_tk, t, "unbeta_tk", 1)), 
                            "assigning variable beta_tk");
            }
            }
            current_statement_begin__ = 113;
            for (int t = 1; t <= T; ++t) {
                current_statement_begin__ = 114;
                stan::model::assign(ungamma_tk, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            elt_multiply(get_base1(alpha_tk, t, "alpha_tk", 1), get_base1(beta_tk, t, "beta_tk", 1)), 
                            "assigning variable ungamma_tk");
                current_statement_begin__ = 115;
                stan::model::assign(gamma_tk, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            normalize(get_base1(ungamma_tk, t, "ungamma_tk", 1), pstream__), 
                            "assigning variable gamma_tk");
            }
            current_statement_begin__ = 118;
            for (int t = 1; t <= T; ++t) {
                current_statement_begin__ = 121;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 126;
                for (int j = 1; j <= K; ++j) {
                    current_statement_begin__ = 127;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                (get_base1(log_lik, t, "log_lik", 1) + (get_base1(get_base1(gamma_tk, t, "gamma_tk", 1), j, "gamma_tk", 2) * get_base1(get_base1(alpha_tk, t, "alpha_tk", 1), j, "alpha_tk", 2))), 
                                "assigning variable log_lik");
                }
                current_statement_begin__ = 133;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            stan::math::log(get_base1(log_lik, t, "log_lik", 1)), 
                            "assigning variable log_lik");
            }
            {
            current_statement_begin__ = 139;
            validate_non_negative_index("a_tk", "T", T);
            validate_non_negative_index("a_tk", "K", K);
            std::vector<std::vector<int  >  > a_tk(T, std::vector<int>(K, int(0)));
            stan::math::fill(a_tk, std::numeric_limits<int>::min());
            current_statement_begin__ = 140;
            validate_non_negative_index("delta_tk", "T", T);
            validate_non_negative_index("delta_tk", "K", K);
            std::vector<std::vector<local_scalar_t__  >  > delta_tk(T, std::vector<local_scalar_t__>(K, local_scalar_t__(DUMMY_VAR__)));
            stan::math::initialize(delta_tk, DUMMY_VAR__);
            stan::math::fill(delta_tk, DUMMY_VAR__);
            current_statement_begin__ = 142;
            if (as_bool(logical_eq(est_sigma, 1))) {
                current_statement_begin__ = 143;
                for (int j = 1; j <= K; ++j) {
                    current_statement_begin__ = 144;
                    stan::model::assign(delta_tk, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(K), stan::model::nil_index_list())), 
                                normal_log(get_base1(x_t, 1, "x_t", 1), get_base1(mu_k, j, "mu_k", 1), get_base1(sigma_k, j, "sigma_k", 1)), 
                                "assigning variable delta_tk");
                }
            } else {
                current_statement_begin__ = 146;
                for (int j = 1; j <= K; ++j) {
                    current_statement_begin__ = 147;
                    stan::model::assign(delta_tk, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(K), stan::model::nil_index_list())), 
                                normal_log(get_base1(x_t, 1, "x_t", 1), get_base1(mu_k, j, "mu_k", 1), get_base1(sigma_t, 1, "sigma_t", 1)), 
                                "assigning variable delta_tk");
                }
            }
            current_statement_begin__ = 150;
            for (int t = 2; t <= T; ++t) {
                current_statement_begin__ = 151;
                for (int j = 1; j <= K; ++j) {
                    current_statement_begin__ = 152;
                    stan::model::assign(delta_tk, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                stan::math::negative_infinity(), 
                                "assigning variable delta_tk");
                    current_statement_begin__ = 153;
                    for (int i = 1; i <= K; ++i) {
                        {
                        current_statement_begin__ = 154;
                        local_scalar_t__ logp(DUMMY_VAR__);
                        (void) logp;  // dummy to suppress unused var warning
                        stan::math::initialize(logp, DUMMY_VAR__);
                        stan::math::fill(logp, DUMMY_VAR__);
                        current_statement_begin__ = 155;
                        if (as_bool(logical_eq(est_sigma, 1))) {
                            current_statement_begin__ = 156;
                            stan::math::assign(logp, ((get_base1(get_base1(delta_tk, (t - 1), "delta_tk", 1), i, "delta_tk", 2) + stan::math::log(get_base1(get_base1(A_ij, i, "A_ij", 1), j, "A_ij", 2))) + normal_log(get_base1(x_t, t, "x_t", 1), get_base1(mu_k, j, "mu_k", 1), get_base1(sigma_k, j, "sigma_k", 1))));
                        } else {
                            current_statement_begin__ = 158;
                            stan::math::assign(logp, ((get_base1(get_base1(delta_tk, (t - 1), "delta_tk", 1), i, "delta_tk", 2) + stan::math::log(get_base1(get_base1(A_ij, i, "A_ij", 1), j, "A_ij", 2))) + normal_log(get_base1(x_t, t, "x_t", 1), get_base1(mu_k, j, "mu_k", 1), get_base1(sigma_t, t, "sigma_t", 1))));
                        }
                        current_statement_begin__ = 160;
                        if (as_bool(logical_gt(logp, get_base1(get_base1(delta_tk, t, "delta_tk", 1), j, "delta_tk", 2)))) {
                            current_statement_begin__ = 161;
                            stan::model::assign(a_tk, 
                                        stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        i, 
                                        "assigning variable a_tk");
                            current_statement_begin__ = 162;
                            stan::model::assign(delta_tk, 
                                        stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                        logp, 
                                        "assigning variable delta_tk");
                        }
                        }
                    }
                }
            }
            current_statement_begin__ = 168;
            stan::math::assign(logp_zstar_t, max(get_base1(delta_tk, T, "delta_tk", 1)));
            current_statement_begin__ = 170;
            for (int j = 1; j <= K; ++j) {
                current_statement_begin__ = 171;
                if (as_bool(logical_eq(get_base1(get_base1(delta_tk, T, "delta_tk", 1), j, "delta_tk", 2), logp_zstar_t))) {
                    current_statement_begin__ = 172;
                    stan::model::assign(zstar_t, 
                                stan::model::cons_list(stan::model::index_uni(T), stan::model::nil_index_list()), 
                                j, 
                                "assigning variable zstar_t");
                }
            }
            current_statement_begin__ = 174;
            for (int t = 1; t <= (T - 1); ++t) {
                current_statement_begin__ = 175;
                stan::model::assign(zstar_t, 
                            stan::model::cons_list(stan::model::index_uni((T - t)), stan::model::nil_index_list()), 
                            get_base1(get_base1(a_tk, ((T - t) + 1), "a_tk", 1), get_base1(zstar_t, ((T - t) + 1), "zstar_t", 1), "a_tk", 2), 
                            "assigning variable zstar_t");
            }
            }
            // validate, write generated quantities
            current_statement_begin__ = 69;
            size_t unbeta_tk_j_1_max__ = K;
            size_t unbeta_tk_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < unbeta_tk_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < unbeta_tk_k_0_max__; ++k_0__) {
                    vars__.push_back(unbeta_tk[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 70;
            size_t ungamma_tk_j_1_max__ = K;
            size_t ungamma_tk_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < ungamma_tk_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < ungamma_tk_k_0_max__; ++k_0__) {
                    vars__.push_back(ungamma_tk[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 71;
            size_t alpha_tk_j_1_max__ = K;
            size_t alpha_tk_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < alpha_tk_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < alpha_tk_k_0_max__; ++k_0__) {
                    vars__.push_back(alpha_tk[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 72;
            size_t beta_tk_j_1_max__ = K;
            size_t beta_tk_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < beta_tk_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_tk_k_0_max__; ++k_0__) {
                    vars__.push_back(beta_tk[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 73;
            size_t gamma_tk_j_1_max__ = K;
            size_t gamma_tk_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < gamma_tk_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < gamma_tk_k_0_max__; ++k_0__) {
                    vars__.push_back(gamma_tk[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 74;
            size_t log_lik_j_1_max__ = T;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
            current_statement_begin__ = 75;
            size_t zstar_t_i_0_max__ = T;
            for (size_t i_0__ = 0; i_0__ < zstar_t_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "zstar_t[i_0__]", zstar_t[i_0__], 1);
                check_less_or_equal(function__, "zstar_t[i_0__]", zstar_t[i_0__], K);
            }
            size_t zstar_t_k_0_max__ = T;
            for (size_t k_0__ = 0; k_0__ < zstar_t_k_0_max__; ++k_0__) {
                vars__.push_back(zstar_t[k_0__]);
            }
            current_statement_begin__ = 76;
            vars__.push_back(logp_zstar_t);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_hmm_gaussian";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t p_1k_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < p_1k_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_1k" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t A_ij_j_1_max__ = K;
        size_t A_ij_k_0_max__ = K;
        for (size_t j_1__ = 0; j_1__ < A_ij_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_ij_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A_ij" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_k_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < mu_k_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_k" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_k_k_0_max__ = K;
        for (size_t k_0__ = 0; k_0__ < sigma_k_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_k" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t unalpha_tk_j_1_max__ = K;
            size_t unalpha_tk_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < unalpha_tk_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < unalpha_tk_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "unalpha_tk" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t unbeta_tk_j_1_max__ = K;
        size_t unbeta_tk_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < unbeta_tk_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < unbeta_tk_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "unbeta_tk" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t ungamma_tk_j_1_max__ = K;
        size_t ungamma_tk_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < ungamma_tk_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ungamma_tk_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ungamma_tk" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t alpha_tk_j_1_max__ = K;
        size_t alpha_tk_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < alpha_tk_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < alpha_tk_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha_tk" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_tk_j_1_max__ = K;
        size_t beta_tk_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < beta_tk_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < beta_tk_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_tk" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t gamma_tk_j_1_max__ = K;
        size_t gamma_tk_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < gamma_tk_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < gamma_tk_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma_tk" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_j_1_max__ = T;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t zstar_t_k_0_max__ = T;
        for (size_t k_0__ = 0; k_0__ < zstar_t_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zstar_t" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "logp_zstar_t";
        param_names__.push_back(param_name_stream__.str());
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t p_1k_j_1_max__ = (K - 1);
        for (size_t j_1__ = 0; j_1__ < p_1k_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_1k" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t A_ij_j_1_max__ = (K - 1);
        size_t A_ij_k_0_max__ = K;
        for (size_t j_1__ = 0; j_1__ < A_ij_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_ij_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A_ij" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_k_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < mu_k_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_k" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_k_k_0_max__ = K;
        for (size_t k_0__ = 0; k_0__ < sigma_k_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_k" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t unalpha_tk_j_1_max__ = K;
            size_t unalpha_tk_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < unalpha_tk_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < unalpha_tk_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "unalpha_tk" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t unbeta_tk_j_1_max__ = K;
        size_t unbeta_tk_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < unbeta_tk_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < unbeta_tk_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "unbeta_tk" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t ungamma_tk_j_1_max__ = K;
        size_t ungamma_tk_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < ungamma_tk_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ungamma_tk_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ungamma_tk" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t alpha_tk_j_1_max__ = K;
        size_t alpha_tk_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < alpha_tk_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < alpha_tk_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha_tk" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_tk_j_1_max__ = K;
        size_t beta_tk_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < beta_tk_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < beta_tk_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_tk" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t gamma_tk_j_1_max__ = K;
        size_t gamma_tk_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < gamma_tk_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < gamma_tk_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma_tk" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_j_1_max__ = T;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t zstar_t_k_0_max__ = T;
        for (size_t k_0__ = 0; k_0__ < zstar_t_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zstar_t" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "logp_zstar_t";
        param_names__.push_back(param_name_stream__.str());
    }
}; // model
}  // namespace
typedef model_hmm_gaussian_namespace::model_hmm_gaussian stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
