% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{print.bayesianVARs_predict}
\alias{print.bayesianVARs_predict}
\title{Print method for bayesianVARs_predict objects}
\usage{
\method{print}{bayesianVARs_predict}(x, ...)
}
\arguments{
\item{x}{A \code{bayesianVARs_predict} object obtained via
\code{\link[=predict.bayesianVARs_bvar]{predict.bayesianVARs_bvar()}}.}

\item{...}{Currently ignored!}
}
\value{
Returns \code{x} invisibly.
}
\description{
Print method for bayesianVARs_predict objects.
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]

# Split data in train and test
train <- data[1:(nrow(data)-4),]
test <- data[-c(1:(nrow(data)-4)),]

# Estimate model using train data only
mod <- bvar(train, quiet = TRUE)

# Simulate from 1-step ahead posterior predictive
predictions <- predict(mod, ahead = 1L)
print(predictions)
}
