% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateTrans.R
\name{CreateTrans}
\alias{CreateTrans}
\title{Create Transition Vector}
\usage{
CreateTrans(ID, Age, State, Death, states)
}
\arguments{
\item{ID}{A vector that specifies the ID for each subject.}

\item{Age}{A vector that indicates each subject's age at this visit.}

\item{State}{A vector or a factor that indicates the state for each subject at this visit.}

\item{Death}{A vector that indicates whether the subject died or not at this visit.}

\item{states}{The total number of states in our data.}
}
\value{
A vector that contains all transitions.
}
\description{
A function used to create transition vectors with data in long format, which requires the \code{dplyr} package.
}
\details{
The rules for creating transitions can be found with \code{?lifedata}. In essence, arrange the data in long format, including details about the present state at time t. This procedure will assist in generating a dataset in long format that captures transitions by utilizing states from both time t-1 and t.
}
\examples{
ID <- rep(1:50, each = 5) 
Age <- rep(31:35, times = 50) 
State <- sample(1:5,size=250,replace=TRUE)  
Death <- rep(c(0,0,0,0,1),times=50)

Example <- data.frame(ID,Age,State,Death)

Example$trans <- CreateTrans(Example$ID,Example$Age, Example$State,Example$Death,states=6)


}
\seealso{
\code{\link{lifedata}}
}
