% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_helper_functions.R
\name{behav_seg_image}
\alias{behav_seg_image}
\title{Internal function that transforms a vector of bin numbers to a
presence-absence matrix}
\usage{
behav_seg_image(dat, nbins)
}
\arguments{
\item{dat}{A data frame for a single animal ID that contains only columns for
the ID and each of the movement variables that were analyzed by
\code{\link{segment_behavior}}. The ID column must be first.}

\item{nbins}{numeric. A vector of the number of bins used to discretize each
movement variable. These must be in the same order as the columns within
\code{data}.}
}
\value{
A list where each element stores the presence-absence matrix for each
  of the movement variables.
}
\description{
Transforms vectors of bin numbers into full matrices for plotting as a
heatmap.
}
