% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbnec.R
\name{ggbnec}
\alias{ggbnec}
\title{ggbnec}
\usage{
ggbnec(x, nec = TRUE, ecx = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}, as returned by function \code{\link{bnec}}.}

\item{nec}{Should NEC values be added to the plot? Defaults to TRUE.}

\item{ecx}{Should ECx values be added to the plot? Defaults to FALSE.}

\item{...}{
  Arguments passed on to \code{\link[=ggbnec.bayesmanecfit]{ggbnec.bayesmanecfit}}
  \describe{
    \item{\code{all}}{Should all individual models be plotted separately (defaults to
TRUE) or should model averaged predictions be plotted instead?}
    \item{\code{plot}}{Should output \code{\link[ggplot2]{ggplot}} output be plotted?
Only relevant if \code{all = TRUE} and \code{multi_facet = FALSE}.}
    \item{\code{ask}}{Indicates if the user is prompted before a new page is plotted.
Only relevant if \code{plot = TRUE} and \code{multi_facet = FALSE}.}
    \item{\code{newpage}}{Indicates if the first set of plots should be plotted to a
new page. Only relevant if \code{plot = TRUE} and
\code{multi_facet = FALSE}.}
    \item{\code{multi_facet}}{Should all plots be plotted in one single panel via
facets? Defaults to FALSE.}
  }}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
\code{\link[bayesnec:bayesnec-package]{bayesnec}} standard ggplot method.
}
\examples{
\donttest{
library(brms)
library(bayesnec)
options(mc.cores = 2)
data(nec_data)

test <- bnec(data = nec_data, x_var = "x", y_var = "y",
             model = c("nec3param", "nec4param"), iter = 2e2,
             family = Beta(link = "identity"))
test2 <- pull_out(test, "nec3param")
ggbnec(test2)
ggbnec(test2, nec = FALSE)
ggbnec(test2, ecx = TRUE, ecx_val = 50)

# plots multiple models, one at a time, with interactive prompt
ggbnec(test)
# plot model averaged predictions
ggbnec(test, all = FALSE)
# plot all panels together
ggbnec(test, ecx = TRUE, ecx_val = 50, multi_facet = TRUE)
}

}
