% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/necsummary-class.R
\docType{class}
\name{necsummary-class}
\alias{necsummary-class}
\alias{necsummary}
\title{Class \code{necsummary} of models fitted with the \pkg{brms} package}
\description{
Single models fitted with the
\code{\link[bayesnec:bayesnec-package]{bayesnec}} package are summarised
as a \code{necsummary} object, which contains the original
\code{\link[brms]{brmsfit}} object summary, the name of the
non-linear model fitted, whether this model is an ECx-type model
(see details below), and the ECx summary values should the user decide
to calculate them.
}
\details{
See \code{methods(class = "necsummary")} for an overview of available
methods.
}
\section{Slots}{

\describe{
\item{\code{brmssummary}}{The standard summary for the fitted Bayesian model of
class \code{\link[brms]{brmsfit}}.}

\item{\code{model}}{A \code{\link[base]{character}} string indicating the name of
the fitted non-linear model.}

\item{\code{is_ecx}}{A \code{\link[base]{logical}} indicating whether \code{model}
is an ECx-type model.}

\item{\code{ecs}}{A \code{\link[base]{list}} containing the ECx values
should the user decide to calculate them (see the non-exported
\code{bayesnec:::summary.bayesnecfit} help file for details).}
}}

\seealso{
\code{\link{bayesnec}},
\code{\link{bnec}},
\code{\link{bayesnecfit}},
\code{\link{bayesmanecfit}},
\code{\link{manecsummary}}
}
