% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amend.R
\name{amend}
\alias{amend}
\title{Amends an existing \code{\link{bayesmanecfit}} object, for example, by
adding or removing fitted models.}
\usage{
amend(
  object,
  drop,
  add,
  loo_controls,
  x_range = NA,
  precision = 1000,
  sig_val = 0.01,
  priors
)
}
\arguments{
\item{object}{An object of class \code{\link{bayesmanecfit}}, as returned
by \code{\link{bnec}}.}

\item{drop}{A \code{\link[base]{character}} vector containing the names of
model types you which to drop for the modified fit.}

\item{add}{A \code{\link[base]{character}} vector containing the names of
model types to add to the modified fit.}

\item{loo_controls}{A named \code{\link[base]{list}} of two elements
("fitting" and/or "weights"), each being a named \code{\link[base]{list}}
containing the desired arguments to be passed on to \code{\link[brms]{loo}}
(via "fitting") or to \code{\link[loo]{loo_model_weights}} (via "weights").
If "fitting" is provided with argument \code{pointwise = TRUE}
(due to memory issues) and \code{family = "beta_binomial2"}, the
\code{\link{bnec}} will fail because that is a custom family. If "weights" is
not provided by the user, \code{\link{bnec}} will set the default
\code{method} argument in \code{\link[loo]{loo_model_weights}} to
"pseudobma". See ?\code{\link[loo]{loo_model_weights}} for further info.}

\item{x_range}{A range of predictor values over which to consider extracting
ECx.}

\item{precision}{The length of the predictor vector used for posterior
predictions, and over which to extract ECx values. Large values will be
slower but more precise.}

\item{sig_val}{Probability value to use as the lower quantile to test
significance of the predicted posterior values against the lowest observed
concentration (assumed to be the control), to estimate NEC as an
interpolated NOEC value from smooth ECx curves.}

\item{priors}{An object of class \code{\link[brms]{brmsprior}} which
specifies user-desired prior distributions of model parameters.
If missing, \code{\link{amend}} will figure out a baseline prior for each
parameter. It can also be specified as a named \code{\link[base]{list}}
where each name needs to correspond to the same string as \code{model}. See
details.}
}
\value{
All successfully fitted \code{\link{bayesmanecfit}} model fits.
}
\description{
Amends an existing \code{\link{bayesmanecfit}} object, for example, by
adding or removing fitted models.
}
\examples{
library(bayesnec)
data(manec_example)
exmp <- amend(manec_example, drop = "nec4param")

}
