#' Book Banning Data
#' 
#' The book banning data was collected by Fast and Hegland as part of a course project
#' at St Olaf College, and distributed with "Broadening Your Statistical Horizons" by Legler and Roback.
#' This data set includes the features and outcomes for 931 book challenges 
#' (ie. requests to ban a book) made in the US between 2000 and 2010.
#' Information on the books being challenged and the characteristics of these books 
#' were collected from the American Library Society. State-level demographic information and 
#' political leanings were obtained from the US Census Bureau and Cook Political Report, respectively.
#' Due to an outlying large number of challenges, book challenges made in the state of Texas 
#' were omitted.
#' 
#' @format A data frame with 931 rows and 17 variables. Each row represents a single book challenge within the given state and date.
#' \describe{
#'   \item{title}{title of book being challenged}
#'   \item{book_id}{identifier for the book}
#'   \item{author}{author of the book}
#'   \item{date}{date of the challenge}
#'   \item{year}{year of the challenge}
#'   \item{removed}{whether or not the challenge was successful (the book was removed)}
#'   \item{explicit}{whether the book was challenged for sexually explicit material}
#'   \item{antifamily}{whether the book was challenged for anti-family material}
#'   \item{occult}{whether the book was challenged for occult material}
#'   \item{language}{whether the book was challenged for inapropriate language}
#'   \item{lgbtq}{whether the book was challenged for LGBTQ material}
#'   \item{violent}{whether the book was challenged for violent material}
#'   \item{state}{US state in which the challenge was made}
#'   \item{political_value_index}{Political Value Index of the state (negative = leans Republican, 0 = neutral, positive = leans Democrat)}
#'   \item{median_income}{median income in the state, relative to the average state median income}
#'   \item{hs_grad_rate}{high school graduation rate, in percent, relative to the average state high school graduation rate}
#'   \item{college_grad_rate}{college graduation rate, in percent, relative to the average state college graduation rate}
#'   }
#' @source Shannon Fast and Thomas Hegland (2011). Book Challenges: A Statistical Examination. Project for Statistics 316-Advanced Statistical Modeling, St. Olaf College.
#' Julie Legler and Paul Roback (2019). Broadening Your Statistical Horizons: Generalized Linear Models and Multilevel Models. \url{https://bookdown.org/roback/bookdown-bysh/}.
#' \url{https://github.com/proback/BeyondMLR/blob/master/data/bookbanningNoTex.csv/}

"book_banning"
