% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{blockBSGR}
\alias{blockBSGR}
\title{Block Gibbs sampler function.}
\usage{
blockBSGR(X, burnIn, iterations, tau = 1, mu = 0, verbose = TRUE)
}
\arguments{
\item{X}{Numeric data matrix, data is assumed to be Gaussian distributed.}

\item{burnIn}{An integer specifying the number of burn-in iterations.}

\item{iterations}{An integer specifying the length of the Markov chain after the burn-in iterations.}

\item{tau}{A double specifying the value of the variance parameter of both the Gaussian and truncated Gaussian distribution in Bayesian graphical ridge prior.}

\item{mu}{A double specifying the value of the mean parameter of both the Gaussian and truncated Gaussian distribution in Bayesian graphical ridge prior.}

\item{verbose}{A logical determining whether the progress of the MCMC sampler should be displayed.}
}
\value{
blockBSGR: List of precision matrices from the Markov chains.
}
\description{
A Bayesian standard graphical ridge-type data-augmented block Gibbs sampler for simulating the posterior distribution of the concentration matrix specifying a Gaussian graphical model.
}
\examples{
# Generate true covariance matrix:
p             <- 10
n             <- 50
SigTrue       <- pracma::Toeplitz(c(0.7^rep(1:p-1)))
CTrue         <- pracma::inv(SigTrue)
# Generate expected value vector:
mu            <- rep(0,p)
# Generate multivariate normal distribution:
set.seed(123)
X             <- MASS::mvrnorm(n,mu=mu,Sigma=SigTrue)
posterior     <- blockBSGR(X,iterations = 1000, burnIn = 500)
}
