context("test-equiv_bf")

con <- rnorm(100)
exp <- rnorm(100)

test_that("equiv_bf yields correct S4 class", {
  expect_is(
    equiv_bf(x = con,
             y = exp),
    "baymedrEquivalence"
  )
  expect_is(
    equiv_bf(n_x = 100,
             n_y = 100,
             mean_x = 10,
             mean_y = 10,
             sd_x = 5,
             sd_y = 5),
    "baymedrEquivalence"
  )
  expect_is(
    equiv_bf(n_x = 100,
             n_y = 100,
             mean_x = 10,
             mean_y = 10,
             ci_margin = 5,
             ci_level = 0.95),
    "baymedrEquivalence"
  )
})

test_that("equiv_bf yields numeric Bayes factor", {
  expect_true(
    is.numeric(equiv_bf(x = con,
                        y = exp)@bf)
  )
  expect_true(
    is.numeric(equiv_bf(n_x = 100,
                        n_y = 100,
                        mean_x = 10,
                        mean_y = 10,
                        sd_x = 5,
                        sd_y = 5)@bf)
  )
  expect_true(
    is.numeric(equiv_bf(n_x = 100,
                        n_y = 100,
                        mean_x = 10,
                        mean_y = 10,
                        ci_margin = 5,
                        ci_level = 0.95)@bf)
  )
})

test_that("equiv_bf gives correct error messages", {
  expect_error(
    equiv_bf(x = con,
             y = exp,
             ci_margin = 5),
    str_c(
      "Only 'x' and 'y' OR 'n_x', 'n_y', 'mean_x', 'mean_y', 'sd_x', and ",
      "'sd_y' (or 'ci_margin' and 'ci_level' instead of 'sd_x' and 'sd_y') ",
      "must be defined."
    ),
    fixed = TRUE
  )
  expect_error(
    equiv_bf(x = con),
    "Both 'x' and 'y' must be defined.",
    fixed = TRUE
  )
  expect_error(
    equiv_bf(n_x = 100,
             n_y = 100,
             mean_x = 10,
             sd_x = 5),
    str_c(
      "All 'n_x', 'n_y', 'mean_x', 'mean_y', 'sd_x', and 'sd_y' (or ",
      "'ci_margin' and 'ci_level' instead of 'sd_x' and 'sd_y') must be ",
      "defined."
    ),
    fixed = TRUE
  )
  expect_error(
    equiv_bf(n_x = 100,
             n_y = 100,
             mean_x = 10,
             mean_y = 10,
             sd_x = 5,
             sd_y = 5,
             ci_margin = 5,
             ci_level = 0.95),
    "Only 'sd_x' and 'sd_y' OR 'ci_margin' and 'ci_level' must be defined.",
    fixed = TRUE
  )
  expect_error(
    equiv_bf(x = con,
             y = c(exp[1:99], NA)),
    "'x' and 'y' must not contain missing values.",
    fixed = TRUE
  )
  expect_error(
    equiv_bf(x = con,
             y = c(exp[1:99], Inf)),
    "'x' and 'y' must not contain infinite values.",
    fixed = TRUE
  )
  expect_error(
    equiv_bf(x = con,
             y = rep(letters[1:10],
                     each = 10)),
    "'x' and 'y' must be numeric vectors.",
    fixed = TRUE
  )
  expect_error(
    equiv_bf(x = con,
             y = exp,
             prior_scale = "x"),
    "'prior_scale' must be a single numeric value.",
    fixed = TRUE
  )
  expect_error(
    equiv_bf(x = con,
             y = exp,
             prior_scale = c(1, 2)),
    "'prior_scale' must be a single numeric value.",
    fixed = TRUE
  )
  expect_error(
    equiv_bf(x = con,
             y = exp,
             interval = "2"),
    "'interval' must be a numeric vector of length one or two.",
    fixed = TRUE
  )
  expect_error(
    equiv_bf(x = con,
             y = exp,
             interval = c(1, 2, 3)),
    "'interval' must be a numeric vector of length one or two.",
    fixed = TRUE
  )
  expect_error(
    equiv_bf(n_x = 100,
             n_y = 100,
             mean_x = 0,
             mean_y = 2,
             ci_margin = 5,
             ci_level = 1.5),
    "'ci_level' must be a single numeric value between 0 and 1.",
    fixed = TRUE
  )
  expect_error(
    equiv_bf(n_x = 100,
             n_y = 100,
             mean_x = 0,
             mean_y = 2,
             ci_margin = 5,
             ci_level = "high"),
    "'ci_level' must be a single numeric value between 0 and 1.",
    fixed = TRUE
  )
  expect_error(
    equiv_bf(n_x = 100,
             n_y = 100,
             mean_x = 0,
             mean_y = 2,
             ci_margin = 5,
             ci_level = c(0.3, 0.7)),
    "'ci_level' must be a single numeric value between 0 and 1.",
    fixed = TRUE
  )
})
