\name{simmap.W}
\alias{simmap.W}
\title{Calculate the weight matrix of a set of regimes on a phylogeny}
\usage{
  simmap.W(tree, pars)
}
\arguments{
  \item{tree}{either a tree of class "phylo" or a cache
  object produced by bayOU's internal functions. Must
  include list element 'maps' which is a simmap
  reconstruction of regime history.}

  \item{pars}{a list of the parameters used to calculate
  the weight matrix. Only pars$alpha is necessary to
  calculate the matrix, but others can be present.}
}
\description{
  These functions calculate weight matrices from regimes
  specified in phytools' simmap format. \code{simmap.W}
  calculates the weight matrix for a set of regimes from a
  phylogeny with a stored regime history. \code{.simmap.W}
  calculates the same matrix, but without checks and is
  generally run internally.
}
\details{
  \code{.simmap.W} is more computationally efficient within
  a mcmc and is used internally. The value of \code{TotExp}
  is supplied to speed computation and reduce redundancy,
  and cache objects must be supplied as the phylogeny, and
  the parameter \code{ntheta} must be present in the list
  \code{pars}.
}

