% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayou-steppingstone.R
\name{make.powerposteriorFn}
\alias{make.powerposteriorFn}
\title{Makes a power posterior function in bayou}
\usage{
make.powerposteriorFn(Bk, priorFn, refFn, model)
}
\arguments{
\item{Bk}{The sequence of steps to be taken from the reference function to the posterior}

\item{priorFn}{The prior function to be used in marginal likelihood estimation}

\item{refFn}{The reference function generated using \code{make.refFn()} from a preexisting mcmc chain}

\item{model}{A string specifying the model type ("OU", "OUrepar", "QG") or a model parameter list}
}
\value{
A function of class "powerposteriorFn" that returns a list of four values: \code{result} (the log density of the power posterior), 
\code{lik} (the log likelihood), \code{prior} (the log prior), \code{ref} the log reference density.
}
\description{
This function generates a power posterior function for estimation of marginal likelihood using the stepping stone method
}
\details{
For use in stepping stone estimation of the marginal likelihood using the method of Fan et al. (2011).
}
