% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_importQW.R
\name{importQW}
\alias{importQW}
\title{Water-Quality Data}
\usage{
importQW(data, keep = c("STAID", "DATES", "TIMES", "MEDIM"),
  values = "VALUE", remark.codes = "REMRK", value.codes = "NWIS",
  reporting.level = "RPLEV", reporting.method = "RLTYP",
  reporting.units = "UNITS", analyte.method = "METHD",
  analyte.name = "PSNAM", unique.code = "PCODE", ColNames = "Auto")
}
\arguments{
\item{data}{the dataset.}

\item{keep}{the names of the columns that represent a single sample and any
other common information.}

\item{values}{the name of the column containing the reported numeric values.}

\item{remark.codes}{he name of the column containing the remark codes.}

\item{value.codes}{the name of the column containing any value modifiers, or
the character string to use. See \bold{Details}.}

\item{reporting.level}{the name of the column containing the reporting level,
or the numeric value to use. See \bold{Details}.}

\item{reporting.method}{the name of the column containing the type of the
reporting level, or the character string to use. See \bold{Details}.}

\item{reporting.units}{the name of the column containing the measurement
units, or the character string to use. See \bold{Details}.}

\item{analyte.method}{the name of the column containing the analytic method,
or the character string to use. See \bold{Details}.}

\item{analyte.name}{the name of the column containing the name of the
analyte, or the character string to use. See \bold{Details}.}

\item{unique.code}{the name of the column containing any unique codes, or the
character string to use. See \bold{Details}.}

\item{ColNames}{the name of the column containing the column name to use to
make column names, the character string to use if only a single analyte, or
"Auto" if the data in \code{unique.code} are USGS parameter codes. See
\bold{Details}.}
}
\value{
A data frame containing the columns in \code{keep} and those
generated by converting the other columns into class "qw."
}
\description{
Converts a dataset containing stacked discrete water-quality sample data to a
dataset representing those data as class "qw."
}
\details{
Only \code{values} and \code{remark.codes} are required. All others can be
interpreted as constant values if the column name is not in \code{data}.  For
automatic generation of column names, see \code{\link{makeColNames}}.\cr
For \code{reporting.level}, it is better to use \code{NA} than to use an
arbitrary small value because the functions to convert to objects for analysis
will create reasonable reporting level values if they are not known.\cr
For other columns when the actual value is not known, the actual value 
is less important for analysis and more important for the user, so 
arbitrary values can be used.
}
\note{
Need some notes
}
\examples{
\dontrun{
# Convert the stacked qw data supplied in smwrData
library(smwrData)
data(QWstacked)
QWstacked$result_va <- as.numeric(QWstacked$result_va) # raw data are character
# The units are both mg/l, no analyte name, generate column names from parameter codes
head(importQW(QWstacked, c("site_no", "sample_dt", "sample_tm", "medium_cd"),
 "result_va", "remark_cd", "val_qual_tx", "rpt_lev_va", "rpt_lev_cd", 
 "mg/l", "meth_cd", "", "parm_cd", "parm_cd"))
# A simple example having the minimum information
data(QW05078470)
importQW(QW05078470, c("DATES", "TIMES"), "P00665", "R00665", "", 0.005, "User", 
"mg/l", "Unk", "Dissolved Phosporus", "00665", "DissP")
}
}
\references{
Lorenz, D.L., 2014, USGSqw OFR.\cr See information about discrete
samples at \url{https://nwis.waterdata.usgs.gov/usa/nwis/qw}.
}
\seealso{
\code{\link{readNWISqw}}, \code{\link{importNWISqw}},
\code{\link{makeColNames}}
}
\keyword{IO}
\keyword{datasets}
\keyword{internal}
