% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layerAggregation.R
\name{.layerAggregation}
\alias{.layerAggregation}
\title{Aggregate data layers}
\usage{
.layerAggregation(df, avgTechnique = "median", layerAggOption = 0)
}
\arguments{
\item{df}{data frame}

\item{avgTechnique}{method for aggregating data ("median"[default]/mean)}

\item{layerAggOption}{(0[default]: no aggregation; 1: combine "S" & "AP"
("SAP"); 2: combine "B" & "BP" ("BBP"); 3: opt 1 & 2 ("SAP", "BBP"); 4:
combine all ("ALL")); 5: combine "S" and "B" ("SB")}
}
\value{
data frame with aggregated data
}
\description{
This function aggregates data layers. Steps: 1) Perform first level error checking
to make sure that the data set contains 'layer' and valid aggregation option was
selected. 2) Perform second level error checking to make sure the aggregation option
selection makes sense (e.g. cannot aggregate "S" and "AP" if no "AP" data are in the
data set). 3) Average the data by taking the median or mean based on user input.
}
\examples{
# retrieve all corrected chlorophyll-a concentrations for Station CB2.2.
# A warning is displayed indicating that data set has layers but user did
# not specify layer in retrieval. layerAggregation then aggregates across
# all layers.
#df  <- dataMB
#df1 <- selectData(df, "chla", "CB2.2")
#df2 <- layerAggregation(df1[[1]], avgTechnique="median", layerAggOption=4)
#str(df2)
}
\keyword{internal}
