% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_importNWISqw.R
\name{importNWISqw}
\alias{importNWISqw}
\title{Water-Quality Data}
\usage{
importNWISqw(sites, params = "All", begin.date = "", end.date = "",
  keep = NULL, use.pnames = FALSE)
}
\arguments{
\item{sites}{a vector of the USGS station identifiers.}

\item{params}{A character string contains the name of a group of parameter
codes, or a vector of parameter codes. See \bold{Details}.}

\item{begin.date}{the earliest date for data, must be a character with the
format "YYYY-mm-dd."}

\item{end.date}{the latest date for data, must be a character with the format
"YYYY-mm-dd."}

\item{keep}{a character vector for any additional columns to retain from the
retrieved data.}

\item{use.pnames}{create colummn names based on pcode (like P00000)? Default
is to generate more English-like names.}
}
\value{
A data frame of the water-quality data of class "qw" organized by
sample. Column names for the water-quality constituents are generated 
automatically, but can be set by the user,
see \code{\link{makeColNames}}.
}
\description{
Imports discrete water-quality sample data from NWISweb.
}
\details{
Valid parameter code groups are "All," or group codes:
\tabular{ll}{
Code \tab Description\cr
INF \tab Information \cr
PHY \tab Physical \cr
INM \tab Inorganics, Major, Metals (major cations) \cr
INN \tab Inorganics, Major, Non-metals (major anions) \cr
NUT \tab Nutrient \cr
MBI \tab Microbiological \cr
BIO \tab Biological \cr
IMN \tab Inorganics, Minor, Non-metals \cr
IMM \tab Inorganics, Minor, Metals \cr
TOX \tab Toxicity \cr
OPE \tab Organics, pesticide \cr
OPC \tab Organics, PCBs \cr
OOT \tab Organics, other \cr
RAD \tab Radiochemical \cr
SED \tab Sediment \cr
POP \tab Population/community \cr
}
}
\note{
The sample information columns that are automatically retained are the 
USGS station identifier, sample date, sample time, time zone code, and medium
code. If composite samples are found in the data, then sample end date and 
sample end time are also included. Use the \code{keep} argument to retain more 
if needed.\cr

NWIS has several remark codes that have special meaning in addition to "<," which
indicates a left-censored value and ">," which indicates a right censored value.
Most other codes are ignored in processing, but passed through and retained as the
remark code in the data; a warning is printed when special remark codes are retained.
NWIS also uses the remark code "M" to indicate whan a result value is rounded to 0. In
that case, \code{importNWISqw} tries to recode the data as less than the reportiong 
level, but is the reporting level is the missing value \code{NA}, the remark code "M"
is retained. Warnings are generated for both conversion and retention of the "M"
remark codes.
}
\examples{

\dontrun{
importNWISqw("05330000", "00608") # Ammonia samples from the Minnesota River at Jordan.
Empty <- importNWISqw('05330000',c('00400','00403'),begin.date='2008-01-01')
}
}
\references{
Lorenz, D.L., 2014, smwrQW OFR.\cr See information about discrete
samples at \url{https://nwis.waterdata.usgs.gov/usa/nwis/qw}.
}
\seealso{
\code{\link{readNWISqw}}
}
\keyword{IO}
\keyword{datasets}
\keyword{internal}
