% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{removeConst}
\alias{removeConst}
\title{Remove Non-varying Predictors}
\usage{
removeConst(x)
}
\arguments{
\item{x}{Data frame containing discrete factor variables in each column}
}
\value{
Data frame omitting non-varying variables from \code{x}.
}
\description{
Constant predictor is identified and removed
}
\details{
Variables with only one factor level is removed from data. Intended
for use before calling \code{\link{bbl}}.
}
\examples{
set.seed(351)
nt <- c('a','c','g','t')
x <- data.frame(v1=sample(nt,size=50,replace=TRUE),
                v2=rep('a',50),v3=sample(nt,size=50,replace=TRUE))
y <- sample(c('case','ctrl'),size=50,replace=TRUE)
dat <- cbind(data.frame(y=y), x)
summary(dat)
dat <- removeConst(dat)
summary(dat)
}
