% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma_Inference.r
\name{dInvGamma}
\alias{dInvGamma}
\title{Density function of Inverse-Gamma distribution}
\usage{
dInvGamma(x, shape, scale, LOG = TRUE)
}
\arguments{
\item{x}{numeric, positive numeric values.}

\item{shape}{numeric, the shape parameter of gamma distribution.}

\item{scale}{numeric, the scale, or inverse-scale parameter of gamma distribution. The 'rate' parameter in Gamma is the 'scale' parameter in InvGamma}

\item{LOG}{logical, return log density of LOG=TRUE, default TRUE.}
}
\value{
A numeric vector, the density values.
}
\description{
For a random variable x, the density function of Inverse-Gamma distribution is defined as:
   \deqn{(rate^shape)/Gamma(shape) x^{-shape-1} exp(-rate/x)}
}
