% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-strata-area.R
\name{get_strata_area}
\alias{get_strata_area}
\title{Get the area of each strata}
\usage{
get_strata_area(strata_type = NULL)
}
\arguments{
\item{strata_type}{Stratification type to return the areas of}
}
\value{
Data frame with the following variables:
  \item{region}{Name of the stratum/region}
  \item{area_sq_km}{Area of the stratum/region in square kilometres}
}
\description{
\code{get_strata_area} allows you to obtain the area of each strata
  for a given stratification type.
}
\examples{

# Obtain the strata area for each of the 5 stratification types

# USGS BBS
st_area <- get_strata_area(strata_type = "bbs_usgs")

# CWS BBS
st_area <- get_strata_area(strata_type = "bbs_cws")

# BCR
st_area <- get_strata_area(strata_type = "bcr")

# State/Province/Territory
st_area <- get_strata_area(strata_type = "state")

# Degree block
st_area <- get_strata_area(strata_type = "latlong")

}
