% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-classes.R, R/utils-select.R
\name{select.bcdc_promise}
\alias{select.bcdc_promise}
\alias{select}
\title{Select columns from bcdc_query_geodata() call}
\usage{
\method{select}{bcdc_promise}(.data, ...)
}
\arguments{
\item{.data}{object of class \code{bcdc_promise} (likely passed from \code{\link[=bcdc_query_geodata]{bcdc_query_geodata()}})}

\item{...}{One or more unquoted expressions separated by commas. See details.}
}
\description{
Similar to a \code{dplyr::select} call, this allows you to select which columns you want the Web Feature Service to return.
A key difference between \code{dplyr::select} and \code{bcdata::select} is the presence of "sticky" columns that are
returned regardless of what columns are selected. If any of these "sticky" columns are selected
only "sticky" columns are return. \code{bcdc_describe_feature} is one way to tell if columns are sticky in advance
of issuing the Web Feature Service call.

See \code{dplyr::\link[dplyr]{select}} for details.
}
\section{Methods (by class)}{
\itemize{
\item \code{select(bcdc_promise)}: select.bcdc_promise

}}
\examples{
\donttest{
try(
  feature_spec <- bcdc_describe_feature("bc-airports")
)

try(
  ## Columns that can selected:
  feature_spec[feature_spec$sticky == TRUE,]
)

## Select columns
try(
  res <- bcdc_query_geodata("bc-airports") \%>\%
    select(DESCRIPTION, PHYSICAL_ADDRESS)
)

## Select "sticky" columns
try(
  res <- bcdc_query_geodata("bc-airports") \%>\%
    select(LOCALITY)
)
}


}
\keyword{internal}
