% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeOperator.R
\docType{methods}
\name{\%>I\%}
\alias{\%>I\%}
\title{bdpar customized forward-pipe operator}
\usage{
lhs \%>I\% rhs
}
\arguments{
\item{lhs}{an \code{\link{Instance}} object.}

\item{rhs}{a function call using the bdpar semantics.}
}
\value{
the \code{\link{Instance}} modified by the methods it has traversed.
}
\description{
Defines a customized fordward pipe operator extending the
features of classical \%>\%. Concretely \%>I\% is able to stop the pipelining
process whenever an \code{\link{Instance}} has been invalidated. This issue,
avoids executing the whole pipelining proccess for the invalidated
\code{\link{Instance}} and therefore reduce the time and resources used to
complete the whole proccess.
}
\section{Details}{

This is the \%>\% operator of the modified magrittr library in order
to stop the flow when the \code{\link{Instance}} is invalid.
}

\section{Note}{

Pipelining proccess is automatically stopped if the \code{\link{Instance}}
is invalid.
}

\seealso{
\code{\link{Instance}}
}
