% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorFactory.R
\docType{class}
\name{ExtractorFactory}
\alias{ExtractorFactory}
\title{Class to handle the creation of Instance types}
\usage{
ExtractorFactory
}
\description{
\code{\link{ExtractorFactory}} class builds the appropriate
\code{\link{Instance}} object according to the file extension.
}
\section{Constructor}{

\code{ExtractorFactory$new()}
}

\section{Methods}{

\itemize{
#' \item{\bold{registerExtractor:}}{
adds an extractor to the list of extensions
\itemize{
\item{\emph{Usage:}}{
\code{registerExtractor(extension, extractor)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{extension:}}{
(\emph{character}) the name of the extension option.
}
\item{\strong{extractor:}}{
(\emph{Object}) the extractor of the new extension.
}
}
}
}
}

\item{\bold{setExtractor:}}{
modifies the extractor of the one extension.
\itemize{
\item{\emph{Usage:}}{
\code{setExtractor(extension, extractor)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{extension:}}{
(\emph{character}) the name of the new extension.
}
\item{\strong{extractor:}}{
(\emph{Instance}) the value of the new extractor.
}
}
}
}
}

\item{\bold{removeExtractor:}}{
removes a specific extractor throught the extension.
\itemize{
\item{\emph{Usage:}}{
\code{removeExtractor(extension)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{extension:}}{
(\emph{character}) the name of the extension to remove.
}
}
}
}
}

\item{\bold{getAllExtractors:}}{
gets the list of extractors.
\itemize{
\item{\emph{Usage:}}{
\code{getAllExtractors()}
}
\item{\emph{Value:}}{
Value of extractors.
}
}
}

\item{\bold{createInstance:}}{
builds the \code{\link{Instance}} object according to the file extension.
\itemize{
\item{\emph{Usage:}}{
\code{createInstance(path)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} corresponding object according to the file extension.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) path of the file to create an \code{\link{Instance}}.
}
}
}
}
}
}
}

\seealso{
\code{\link{ExtractorEml}}, \code{\link{ExtractorSms}},
\code{\link{ExtractorTwtid}}, \code{\link{ExtractorYtbid}},
\code{\link{Instance}}
}
