% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureLengthPipe.R
\docType{class}
\name{MeasureLengthPipe}
\alias{MeasureLengthPipe}
\title{Class to obtain the length of the data field of an Instance}
\usage{
MeasureLengthPipe
}
\description{
This class is responsible of obtain the length of the\strong{data}
field of each \code{\link{Instance}}. Creates the \strong{length} property
which indicates the length of the text. The property's name is customize
throught the class constructor.
}
\section{Constructor}{

\preformatted{
MeasureLengthPipe$new(propertyName = "length",
                      alwaysBeforeDeps = list(),
                      notAfterDeps = list(),
                      nchar_conf = TRUE)
}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
\item{\strong{nchar_conf}}{
(\emph{logical}) indicates if the Pipe uses nchar or object.size.
}
}
}
}
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain the length of data.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
}
}
}
}

\item{\bold{getLength:}}{
obtains the length of the data.
\itemize{
\item{\emph{Usage:}}{
\code{getLength(data, nchar_conf = TRUE)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text to preproccess.
}
\item{\strong{nchar_conf:}}{
(\emph{logical}) indicates if the Pipe uses nchar or object.size.
}
}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{nchar_conf:}}{
 (\emph{logical}) indicates if the Pipe uses nchar or object.size.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{FindUserNamePipe}},
         \code{\link{GuessDatePipe}}, \code{\link{GuessLanguagePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{GenericPipe}}, \code{\link{ResourceHandler}},
         \code{\link{SlangPipe}}, \code{\link{StopWordPipe}},
         \code{\link{StoreFileExtPipe}}, \code{\link{TargetAssigningPipe}},
         \code{\link{TeeCSVPipe}}, \code{\link{ToLowerCasePipe}}
}
