% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlangPipe.R
\name{SlangPipe}
\alias{SlangPipe}
\title{Class to find and/or replace the slangs on the data field of an Instance}
\description{
\code{\link{SlangPipe}} class is responsible for detecting
the existing slangs in the \strong{data} field of each \code{\link{Instance}}.
Identified slangs are stored inside the \strong{slang} field of
\code{\link{Instance}} class. Moreover if needed, is able to perform inline
slangs replacement.
}
\section{Details}{

\code{\link{SlangPipe}} class requires the resource files (in json format)
containing the correspondence between slangs and meaning. To this end,
the language of the text indicated in the \emph{propertyLanguageName} should
be contained in the resource file name (ie. slang.xxx.json where xxx is the
value defined in the \emph{propertyLanguageName} ). The location of the
resources should be defined in the \strong{"resources.slangs.path"} field of
\emph{\link{bdpar.Options}} variable.
}

\section{Note}{

\code{\link{SlangPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{ContractionPipe}}, \code{\link{File2Pipe}},
         \code{\link{FindEmojiPipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{GenericPipe}}, \code{\link{ResourceHandler}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{SlangPipe}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SlangPipe$new()}}
\item \href{#method-pipe}{\code{SlangPipe$pipe()}}
\item \href{#method-findSlang}{\code{SlangPipe$findSlang()}}
\item \href{#method-replaceSlang}{\code{SlangPipe$replaceSlang()}}
\item \href{#method-getPropertyLanguageName}{\code{SlangPipe$getPropertyLanguageName()}}
\item \href{#method-getResourcesSlangsPath}{\code{SlangPipe$getResourcesSlangsPath()}}
\item \href{#method-setResourcesSlangsPath}{\code{SlangPipe$setResourcesSlangsPath()}}
\item \href{#method-clone}{\code{SlangPipe$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps">}\href{../../bdpar/html/GenericPipe.html#method-getAlwaysBeforeDeps}{\code{bdpar::GenericPipe$getAlwaysBeforeDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps">}\href{../../bdpar/html/GenericPipe.html#method-getNotAfterDeps}{\code{bdpar::GenericPipe$getNotAfterDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName">}\href{../../bdpar/html/GenericPipe.html#method-getPropertyName}{\code{bdpar::GenericPipe$getPropertyName()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash">}\href{../../bdpar/html/GenericPipe.html#method-hash}{\code{bdpar::GenericPipe$hash()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps">}\href{../../bdpar/html/GenericPipe.html#method-setAlwaysBeforeDeps}{\code{bdpar::GenericPipe$setAlwaysBeforeDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps">}\href{../../bdpar/html/GenericPipe.html#method-setNotAfterDeps}{\code{bdpar::GenericPipe$setNotAfterDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName">}\href{../../bdpar/html/GenericPipe.html#method-setPropertyName}{\code{bdpar::GenericPipe$setPropertyName()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{SlangPipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlangPipe$new(
  propertyName = "langpropname",
  propertyLanguageName = "language",
  alwaysBeforeDeps = list("GuessLanguagePipe"),
  notAfterDeps = list(),
  replaceSlangs = TRUE,
  resourcesSlangsPath = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{propertyLanguageName}}{A \code{\link{character}} value. Name of the
language property.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}

\item{\code{replaceSlangs}}{A \code{\link{logical}} value. Indicates if
the slangs are replaced or not.}

\item{\code{resourcesSlangsPath}}{A \code{\link{character}} value. Path
of resource files (in json format) containing the correspondence between
slangs and meaning.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to obtain/replace
the slangs. The slangs found in the data are added to the
list of properties of the \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlangPipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-findSlang"></a>}}
\if{latex}{\out{\hypertarget{method-findSlang}{}}}
\subsection{Method \code{findSlang()}}{
Checks if the slang is in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlangPipe$findSlang(data, slang)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. The text where slang
will be searched.}

\item{\code{slang}}{A \code{\link{character}} value. Indicates the
slang to find.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{logical}} value depending on whether the
slang is in the data.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-replaceSlang"></a>}}
\if{latex}{\out{\hypertarget{method-replaceSlang}{}}}
\subsection{Method \code{replaceSlang()}}{
Replaces the \emph{slang} in the data for the
\emph{extendedSlang}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlangPipe$replaceSlang(slang, extendedSlang, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{slang}}{A \code{\link{character}} value. Indicates the
slang to replace.}

\item{\code{extendedSlang}}{A \code{\link{character}} value. Indicates the
string to replace for the slangs found.}

\item{\code{data}}{A \code{\link{character}} value. The text where slang
will be replaced.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The data with the slangs replaced.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPropertyLanguageName"></a>}}
\if{latex}{\out{\hypertarget{method-getPropertyLanguageName}{}}}
\subsection{Method \code{getPropertyLanguageName()}}{
Gets the name of property language.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlangPipe$getPropertyLanguageName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of name of property language.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getResourcesSlangsPath"></a>}}
\if{latex}{\out{\hypertarget{method-getResourcesSlangsPath}{}}}
\subsection{Method \code{getResourcesSlangsPath()}}{
Gets the path of slangs resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlangPipe$getResourcesSlangsPath()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of path of slangs resources.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setResourcesSlangsPath"></a>}}
\if{latex}{\out{\hypertarget{method-setResourcesSlangsPath}{}}}
\subsection{Method \code{setResourcesSlangsPath()}}{
Sets the path of slangs resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlangPipe$setResourcesSlangsPath(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. The new value of the path of
slangs resources.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlangPipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
