% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindUserNamePipe.R
\name{FindUserNamePipe}
\alias{FindUserNamePipe}
\title{Class to find and/or remove the users on the data field of an Instance}
\description{
This class is responsible of detecting the existing use names in the
\strong{data} field of each \code{\link{Instance}}. Identified user names are
stored inside the \strong{userName} field of \code{\link{Instance}} class.
Moreover if required, is able to perform inline user name removement.
}
\section{Details}{

The regular expressions indicated in the \code{userPattern}
variable are used to identify user names.
}

\section{Note}{

\code{\link{FindUserNamePipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{GenericPipe}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{FindUserNamePipe}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{userPattern}}{A \code{\link{character}} value. The regular
expression to detect name users.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FindUserNamePipe-new}{\code{FindUserNamePipe$new()}}
\item \href{#method-FindUserNamePipe-pipe}{\code{FindUserNamePipe$pipe()}}
\item \href{#method-FindUserNamePipe-findUserName}{\code{FindUserNamePipe$findUserName()}}
\item \href{#method-FindUserNamePipe-removeUserName}{\code{FindUserNamePipe$removeUserName()}}
\item \href{#method-FindUserNamePipe-clone}{\code{FindUserNamePipe$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getAlwaysBeforeDeps'><code>bdpar::GenericPipe$getAlwaysBeforeDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getNotAfterDeps'><code>bdpar::GenericPipe$getNotAfterDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getPropertyName'><code>bdpar::GenericPipe$getPropertyName()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-hash'><code>bdpar::GenericPipe$hash()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setAlwaysBeforeDeps'><code>bdpar::GenericPipe$setAlwaysBeforeDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setNotAfterDeps'><code>bdpar::GenericPipe$setNotAfterDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setPropertyName'><code>bdpar::GenericPipe$setPropertyName()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUserNamePipe-new"></a>}}
\if{latex}{\out{\hypertarget{method-FindUserNamePipe-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{FindEmoticonPipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUserNamePipe$new(
  propertyName = "userName",
  alwaysBeforeDeps = list(),
  notAfterDeps = list(),
  removeUser = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}

\item{\code{removeUser}}{A \code{\link{logical}} value. Indicates if the
name users are removed.}

\item{\code{propertyLanguageName}}{A \code{\link{character}} value. Name of the
language property.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUserNamePipe-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-FindUserNamePipe-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to obtain/remove
the name users. The emoticons found in the data are added to the
list of properties of the \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUserNamePipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUserNamePipe-findUserName"></a>}}
\if{latex}{\out{\hypertarget{method-FindUserNamePipe-findUserName}{}}}
\subsection{Method \code{findUserName()}}{
Finds the \emph{name users} in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUserNamePipe$findUserName(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. The text to search the
name users.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{list}} with name users found.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUserNamePipe-removeUserName"></a>}}
\if{latex}{\out{\hypertarget{method-FindUserNamePipe-removeUserName}{}}}
\subsection{Method \code{removeUserName()}}{
Removes the \emph{name users} in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUserNamePipe$removeUserName(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. The text where name users
will be removed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The data with the name users removed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUserNamePipe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FindUserNamePipe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUserNamePipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
