% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetAssigningPipe.R
\name{TargetAssigningPipe}
\alias{TargetAssigningPipe}
\title{Class to get the target field of the Instance}
\description{
This class allows searching in the path the \strong{target} of
the \code{\link{Instance}}.
}
\section{Details}{

The targets that are searched can be controlled through the
constructor of the class where \emph{targetsName} will be the string that is
searched within the path and targets has the values that the property can
take.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{FindUserNamePipe}},
         \code{\link{GuessDatePipe}}, \code{\link{GuessLanguagePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{GenericPipe}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TeeCSVPipe}}, \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{TargetAssigningPipe}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TargetAssigningPipe-new}{\code{TargetAssigningPipe$new()}}
\item \href{#method-TargetAssigningPipe-pipe}{\code{TargetAssigningPipe$pipe()}}
\item \href{#method-TargetAssigningPipe-getTarget}{\code{TargetAssigningPipe$getTarget()}}
\item \href{#method-TargetAssigningPipe-checkTarget}{\code{TargetAssigningPipe$checkTarget()}}
\item \href{#method-TargetAssigningPipe-getTargets}{\code{TargetAssigningPipe$getTargets()}}
\item \href{#method-TargetAssigningPipe-clone}{\code{TargetAssigningPipe$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getAlwaysBeforeDeps'><code>bdpar::GenericPipe$getAlwaysBeforeDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getNotAfterDeps'><code>bdpar::GenericPipe$getNotAfterDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getPropertyName'><code>bdpar::GenericPipe$getPropertyName()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-hash'><code>bdpar::GenericPipe$hash()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setAlwaysBeforeDeps'><code>bdpar::GenericPipe$setAlwaysBeforeDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setNotAfterDeps'><code>bdpar::GenericPipe$setNotAfterDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setPropertyName'><code>bdpar::GenericPipe$setPropertyName()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetAssigningPipe-new"></a>}}
\if{latex}{\out{\hypertarget{method-TargetAssigningPipe-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{TargetAssigningPipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetAssigningPipe$new(
  targets = list("ham", "spam"),
  targetsName = list("_ham_", "_spam_"),
  propertyName = "target",
  alwaysBeforeDeps = list(),
  notAfterDeps = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{targets}}{A \code{\link{list}} value. Name of the targets property.}

\item{\code{targetsName}}{A \code{\link{list}} value. The name of folders.}

\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetAssigningPipe-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-TargetAssigningPipe-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to obtain the
target.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetAssigningPipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetAssigningPipe-getTarget"></a>}}
\if{latex}{\out{\hypertarget{method-TargetAssigningPipe-getTarget}{}}}
\subsection{Method \code{getTarget()}}{
Gets the target from a path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetAssigningPipe$getTarget(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. The path to analyze.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The target of the path.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetAssigningPipe-checkTarget"></a>}}
\if{latex}{\out{\hypertarget{method-TargetAssigningPipe-checkTarget}{}}}
\subsection{Method \code{checkTarget()}}{
Checks if the target is in the path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetAssigningPipe$checkTarget(target, path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target}}{A \code{\link{character}} value. The target to find in the
path.}

\item{\code{path}}{A \code{\link{character}} value. The path to analize.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
if the target is found, returns target, else returns "".
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetAssigningPipe-getTargets"></a>}}
\if{latex}{\out{\hypertarget{method-TargetAssigningPipe-getTargets}{}}}
\subsection{Method \code{getTargets()}}{
Gets of targets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetAssigningPipe$getTargets()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of targets.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetAssigningPipe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TargetAssigningPipe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetAssigningPipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
