% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToLowerCasePipe.R
\name{ToLowerCasePipe}
\alias{ToLowerCasePipe}
\title{Class to convert the data field of an Instance to lower case}
\description{
Class to convert the data field of an \code{\link{Instance}}
to lower case.
}
\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{FindUserNamePipe}},
         \code{\link{GuessDatePipe}}, \code{\link{GuessLanguagePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{GenericPipe}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{ToLowerCasePipe}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ToLowerCasePipe-new}{\code{ToLowerCasePipe$new()}}
\item \href{#method-ToLowerCasePipe-pipe}{\code{ToLowerCasePipe$pipe()}}
\item \href{#method-ToLowerCasePipe-toLowerCase}{\code{ToLowerCasePipe$toLowerCase()}}
\item \href{#method-ToLowerCasePipe-clone}{\code{ToLowerCasePipe$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getAlwaysBeforeDeps'><code>bdpar::GenericPipe$getAlwaysBeforeDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getNotAfterDeps'><code>bdpar::GenericPipe$getNotAfterDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getPropertyName'><code>bdpar::GenericPipe$getPropertyName()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-hash'><code>bdpar::GenericPipe$hash()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setAlwaysBeforeDeps'><code>bdpar::GenericPipe$setAlwaysBeforeDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setNotAfterDeps'><code>bdpar::GenericPipe$setNotAfterDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setPropertyName'><code>bdpar::GenericPipe$setPropertyName()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToLowerCasePipe-new"></a>}}
\if{latex}{\out{\hypertarget{method-ToLowerCasePipe-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{ToLowerCasePipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToLowerCasePipe$new(
  propertyName = "",
  alwaysBeforeDeps = list(),
  notAfterDeps = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToLowerCasePipe-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-ToLowerCasePipe-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to convert the
data to lower case.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToLowerCasePipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToLowerCasePipe-toLowerCase"></a>}}
\if{latex}{\out{\hypertarget{method-ToLowerCasePipe-toLowerCase}{}}}
\subsection{Method \code{toLowerCase()}}{
Converts the data to lower case
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToLowerCasePipe$toLowerCase(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. Text to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The data in lower case.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToLowerCasePipe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ToLowerCasePipe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToLowerCasePipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
