% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-middleware.R
\name{serveStaticFiles}
\alias{serveStaticFiles}
\title{File-serving middleware}
\usage{
serveStaticFiles(
  beakr = NULL,
  urlPath = NULL,
  rootPath = getwd(),
  rawTypesPattern = "image|json|octet|pdf|video"
)
}
\arguments{
\item{beakr}{\code{Beakr} instance or \code{NULL}.}

\item{urlPath}{String representing the URL directory undnerneath which static
file paths will appear.}

\item{rootPath}{String representing the absolute path used as the root
directory when searching for files on host machine. Defaults to the directory
in which the script is running.}

\item{rawTypesPattern}{String pattern identifying mime types to be returned
as raw bytes.}
}
\value{
A \code{Beakr} instance with added middleware.
}
\description{
Binds to GET requests that aren't handled by specified paths.
The result is to return files that are found on the host machine at the
requested path. Binary file types like \code{.png}, \code{.gif} or
\code{.pdf} are returned as raw bytes. All others are returned as characters.

Mime types are guessed using the \pkg{mime} package. The \code{rawTypesPattern}
parameter is used to match mime types that should be returned as raw bytes.
}
\details{
All files to be served in this manner must exist underneath the
host machine directory specified with \code{rootPath}. The directory
structure underneath \code{rootPath} will be mapped onto URLs underneath
\code{urlPath}. This helps when deploying web services at preordained URLs.

For example, specifying:

\preformatted{
beakr %>%
  ...
  serverStaticFiles("/data-service/A", "/data/project_A/public")
  ...
  listen()
}

will allow a file found on the host machine at:
\preformatted{
  /data/project_A/public/2019/averages.csv"
}
to be downloaded from:
\preformatted{
  http://<ip-address>:<port>/data-service/A/2019/averages.csv"
}
}
