% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files_exist.R
\name{files_exist}
\alias{files_exist}
\title{Checks if all files exist.}
\usage{
files_exist(filenames)
}
\arguments{
\item{filenames}{one or more filename}
}
\value{
TRUE if all files exists, FALSE otherwise
}
\description{
Multi-file \link{file.exists} function
}
\examples{
  library(testthat)

  filename_1 <- get_beastier_path("beast2_example_output.log")
  filename_2 <- get_beastier_path("beast2_example_output.trees")
  absent <- tempfile()

  expect_true(files_exist(filename_1))
  expect_true(files_exist(filename_2))
  expect_false(files_exist(absent))

  expect_true(files_exist(c(filename_1, filename_2)))
  expect_false(files_exist(c(filename_1, absent)))
  expect_false(files_exist(c(absent, filename_2)))
}
\author{
Richèl J.C. Bilderbeek
}
