% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps.R
\name{prop_scr_love}
\alias{prop_scr_love}
\title{Love Plot of the Absolute Standardized Mean Differences}
\usage{
prop_scr_love(x, reference_line = NULL, ...)
}
\arguments{
\item{x}{Propensity score object}

\item{reference_line}{Numeric value of where along the x-axis the vertical
reference line should be placed}

\item{...}{Optional options for \code{geom_point}}
}
\value{
ggplot object
}
\description{
Plot the unadjusted and IPW-adjusted absolute standardized mean
differences for each covariate.
}
\examples{
library(dplyr)
ps_obj <- calc_prop_scr(internal_df = filter(int_norm_df, trt == 0),
                       external_df = ex_norm_df,
                       id_col = subjid,
                       model = ~ cov1 + cov2 + cov3 + cov4)
# Plotting the Propensity Scores
prop_scr_love(ps_obj, reference_line = 0.1)

}
