% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_file.R
\name{create_beast2_input_file}
\alias{create_beast2_input_file}
\title{Create a BEAST2 input file}
\usage{
create_beast2_input_file(input_filenames, output_filename,
  site_models = create_jc69_site_models(ids = get_ids(input_filenames)),
  clock_models = create_strict_clock_models(ids = get_ids(input_filenames)),
  tree_priors = create_yule_tree_priors(ids = get_ids(input_filenames)),
  mrca_priors = NA, mcmc = create_mcmc(), posterior_crown_age = NA)
}
\arguments{
\item{input_filenames}{One or more FASTA filenames.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{output_filename}{Name of the XML parameter file created by this
function. BEAST2 uses this file as input.}

\item{site_models}{one or more site models,
as returned by \code{\link{create_site_model}}}

\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}

\item{tree_priors}{one or more tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mrca_priors}{a list of one or more Most Recent Common Ancestor priors,
as returned by \code{\link{create_mrca_prior}}}

\item{mcmc}{one mcmc object,
as returned by \code{\link{create_mcmc}}}

\item{posterior_crown_age}{the crown age the posteriors'
phylogenies will be fixed at. If NA, crown age is estimated by BEAST2.}
}
\description{
Create a BEAST2 input file
}
\examples{
  # The file created by beautier, a BEAST2 input file
  output_filename <- "create_beast2_input_file.xml"

  # Birth-Death tree prior, crown age is estimated
  create_beast2_input_file(
    get_fasta_filename(),
    output_filename
  )
  testthat::expect_true(file.exists(output_filename))

  # The file created by beautier, a BEAST2 input file
  output_filename_fixed <- "create_beast2_input_file_fixed.xml"

  # Birth-Death tree prior, crown age is fixed at 15 time units
  create_beast2_input_file(
    get_fasta_filename(),
    output_filename_fixed,
    posterior_crown_age = 15
  )
  testthat::expect_true(file.exists(output_filename_fixed))
}
\seealso{
See \code{\link{create_site_model}} for examples with
  different site models. See \code{\link{create_clock_model}} for examples
  with clock models. See \code{\link{create_tree_prior}} for examples with
  different tree priors. See \code{\link{create_mcmc}} for examples with
  a different MCMC setup.
}
\author{
Richel J.C. Bilderbeek
}
