% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_run.R
\name{create_beast2_input_run}
\alias{create_beast2_input_run}
\title{Creates the state section of a BEAST2 XML parameter file}
\usage{
create_beast2_input_run(ids, site_models = create_jc69_site_models(ids = ids),
  clock_models = create_strict_clock_models(ids = ids),
  tree_priors = create_yule_tree_priors(ids = ids), mrca_priors = NA,
  mcmc = create_mcmc(), fixed_crown_ages = rep(FALSE, times = length(ids)),
  initial_phylogenies = rep(NA, length(ids)))
}
\arguments{
\item{ids}{the IDs of the alignments (can be extracted from
their FASTA filesnames using \code{\link{get_ids}})}

\item{site_models}{one or more site models,
as returned by \code{\link{create_site_model}}}

\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}

\item{tree_priors}{one or more tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mrca_priors}{a list of one or more Most Recent Common Ancestor priors,
as returned by \code{\link{create_mrca_prior}}}

\item{mcmc}{one mcmc object,
as returned by \code{\link{create_mcmc}}}

\item{fixed_crown_ages}{one or more booleans to determine if the
phylogenies' crown ages are fixed.
If FALSE, crown age is estimated by BEAST2. If TRUE,
the crown age is fixed to the crown age
of the initial phylogeny.}

\item{initial_phylogenies}{initial phylogenies, can be NAs if random
phylogenies are desired}
}
\description{
Creates the state section of a BEAST2 XML parameter file
}
\author{
Richel J.C. Bilderbeek
}
