% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tree_prior.R
\name{create_tree_prior}
\alias{create_tree_prior}
\title{Internal function to create a tree prior}
\usage{
create_tree_prior(name, id, ...)
}
\arguments{
\item{name}{the tree prior name. Can be any name
in \code{\link{get_tree_prior_names}}}

\item{id}{the ID of the alignment}

\item{...}{specific tree prior parameters}
}
\value{
a tree_prior
}
\description{
Internal function to create a tree prior
}
\note{
Prefer the use the named functions
  \code{\link{create_bd_tree_prior}},
  \code{\link{create_cbs_tree_prior}},
  \code{\link{create_ccp_tree_prior}}
  \code{\link{create_cep_tree_prior}}
  and \code{\link{create_yule_tree_prior}}
  instead
}
\examples{
  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_tree_prior_bd.xml",
    tree_priors = create_bd_tree_prior()
  )
  testit::assert(file.exists("create_tree_prior_bd.xml"))

  create_beast2_input_file(
    input_filenames = get_beautier_path("test_output_6.fas"),
    "create_tree_prior_cbs.xml",
    tree_priors = create_cbs_tree_prior()
  )
  testit::assert(file.exists("create_tree_prior_cbs.xml"))

  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_tree_prior_ccp.xml",
    tree_priors = create_ccp_tree_prior()
  )
  testit::assert(file.exists("create_tree_prior_ccp.xml"))

  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_tree_prior_cep.xml",
    tree_priors = create_cep_tree_prior()
  )
  testit::assert(file.exists("create_tree_prior_cep.xml"))

  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_tree_prior_yule.xml",
    tree_priors = create_yule_tree_prior()
  )
  testit::assert(file.exists("create_tree_prior_yule.xml"))
}
\seealso{
See
  \code{\link{create_bd_tree_prior}},
  \code{\link{create_cbs_tree_prior}},
  \code{\link{create_ccp_tree_prior}}
  \code{\link{create_cep_tree_prior}}
  and \code{\link{create_yule_tree_prior}}
  for more examples using those functions
}
\author{
Richel J.C. Bilderbeek
}
