% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ids.R
\name{get_ids}
\alias{get_ids}
\title{Conclude the IDs from one or more FASTA filenames}
\usage{
get_ids(fasta_filenames, capitalize_first_char_id = FALSE)
}
\arguments{
\item{fasta_filenames}{One or more FASTA filenames.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{capitalize_first_char_id}{capitalize the first character of the IDs}
}
\value{
the IDs
}
\description{
Conclude the IDs from one or more FASTA filenames
}
\examples{
  # Basic usage
  testit::assert(get_ids(c("a.fas", "b.fas")) == c("a", "b"))

  # Usage to create a BEAST2 XML file
  fasta_filenames <- get_beautier_paths(
    c("anthus_aco.fas", "anthus_nd2.fas")
  )
  clock_models <- create_strict_clock_models(
    ids = get_ids(fasta_filenames)
  )

  create_beast2_input_file(
    fasta_filenames,
    "create_strict_clock_models.xml",
    clock_models = clock_models
  )
  testit::assert(file.exists("create_strict_clock_models.xml"))
}
\seealso{
Use \code{\link{get_id}} for one filename
}
\author{
Richel J.C. Bilderbeek
}
