% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_mcmc.R
\name{is_mcmc_nested_sampling}
\alias{is_mcmc_nested_sampling}
\alias{is_nested_sampling_mcmc}
\title{Determine if the object is a valid Nested-Sampling MCMC,
  as used in [1]}
\usage{
is_mcmc_nested_sampling(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid MCMC}
}
\value{
TRUE if x is a valid Nested-Sampling MCMC, FALSE otherwise
}
\description{
Determine if the object is a valid Nested-Sampling MCMC,
  as used in [1]
}
\examples{
  testthat::expect_false(is_nested_sampling_mcmc(create_mcmc()))
  testthat::expect_true(
    is_nested_sampling_mcmc(create_nested_sampling_mcmc())
  )
  testthat::expect_false(is_nested_sampling_mcmc("nonsense"))
}
\references{
* [1] Patricio Maturana Russel, Brendon J Brewer, Steffen Klaere,
    Remco R Bouckaert; Model Selection and Parameter Inference in
    Phylogenetics Using Nested Sampling, Systematic Biology, 2018,
    syy050, https://doi.org/10.1093/sysbio/syy050
}
\seealso{
Use \code{\link{create_mcmc_nested_sampling}}
}
\author{
Richèl J.C. Bilderbeek
}
