% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_alignment_id.R
\name{check_alignment_id}
\alias{check_alignment_id}
\title{Check if the \code{alignment_id} is valid.}
\usage{
check_alignment_id(alignment_id)
}
\arguments{
\item{alignment_id}{ID of the alignment,
as returned by \link{get_alignment_id}.
Keep at \code{NA} to have it initialized automatically}
}
\description{
Will \link{stop} if not.
}
\examples{
library(testthat)

# Path need not exist, use UNIX path as example
created <- get_alignment_id("/home/homer/anthus_aco_sub.fas")
expected <- "anthus_aco_sub"
expect_equal(created, expected)
expect_silent(check_alignment_id(created))
}
