% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_loggers_xml.R
\name{create_loggers_xml}
\alias{create_loggers_xml}
\title{Creates the three logger sections of a BEAST2 XML parameter file}
\usage{
create_loggers_xml(input_filename, inference_model)
}
\arguments{
\item{input_filename}{A FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{inference_model}{an Bayesian phylogenetic inference model,
as can be created by \code{\link{create_inference_model}}.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.}
}
\description{
The logger section has these elements:
\preformatted{
 <logger id="tracelog" [...]>
     [...]
 </logger>
 <logger id="screenlog" [...]>
     [...]
 </logger>
 <logger id="treelog.t:[alignment ID]"  [...]>
     [...]
 </logger>
}
}
\seealso{
Use \link{create_tracelog_xml} to create the XML text
of the logger with the \code{tracelog} ID.
Use \link{create_screenlog_xml} to create the XML text
of the logger with the \code{screenlog} ID.
Use \link{create_treelog_xml} to create the XML text
of the loggers with the \code{treelog} ID.
}
\author{
Richèl J.C. Bilderbeek
}
