% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_beast.R
\name{create_beast2_input_beast}
\alias{create_beast2_input_beast}
\title{Creates the XML text for the \code{beast} tag of a BEAST2 parameter file.}
\usage{
create_beast2_input_beast(
  input_filename,
  inference_model = create_inference_model()
)
}
\arguments{
\item{input_filename}{A FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
lines of XML text
}
\description{
The \code{beast} tag has these elements:
\preformatted{
  <beast[...]>
      <data
      [...]
      </data>
      [map names]
      <run[...]>
      [...]
      </run>
  </beast>
}
}
\seealso{
Use \link{create_beast2_input_from_model} to create the complete XML text.
Use \link{create_beast2_input_data} to create the XML text for
  the \code{data} tag only.
Use \link{create_beast2_input_map} to create the XML text for
  the \code{[map names]} part.
Use \link{create_beast2_input_run} to create the XML text for
  the \code{run} tag only.
}
\author{
Richèl J.C. Bilderbeek
}
