% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_log_normal_distr}
\alias{create_log_normal_distr}
\alias{create_distr_log_normal}
\title{Create a log-normal distribution}
\usage{
create_log_normal_distr(
  id = NA,
  m = 0,
  s = 0,
  value = NA,
  lower = NA,
  upper = NA
)
}
\arguments{
\item{id}{the distribution's ID}

\item{m}{the m parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_m_param}}}

\item{s}{the s parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_s_param}}}

\item{value}{the initial value for the MCMC}

\item{lower}{the lower bound, the lowest possible value}

\item{upper}{an upper limit of the uniform distribution.
If the upper limits needs to be infinity, set \code{upper} to \code{Inf}.}
}
\value{
a log-normal distribution
}
\description{
Create a log-normal distribution
}
\examples{
  log_normal_distr <- create_log_normal_distr()

  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    input_filename = get_fasta_filename(),
    beast2_input_file,
    tree_prior = create_yule_tree_prior(
      birth_rate_distr = log_normal_distr
    )
  )
  testit::assert(file.exists(beast2_input_file))
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richèl J.C. Bilderbeek
}
