% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_rln_clock_model.R
\name{has_rln_clock_model}
\alias{has_rln_clock_model}
\title{Determine if the \code{inference_model} uses
a relaxed log-normal clock model.}
\usage{
has_rln_clock_model(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
TRUE if the \code{inference_model} uses
a relaxed log-normal clock model,
FALSE otherwise
}
\description{
Determine if the \code{inference_model} uses
a relaxed log-normal clock model.
}
\examples{
# Yes, has a RLN clock model
has_rln_clock_model(
  create_inference_model(clock_model = create_rln_clock_model())
)

# No RLN clock model
has_rln_clock_model(
  create_inference_model(clock_model = create_strict_clock_model())
)
}
\author{
Richèl J.C. Bilderbeek
}
