% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mcmc_nested_sampling.R
\name{create_ns_mcmc}
\alias{create_ns_mcmc}
\alias{create_mcmc_nested_sampling}
\title{Create an MCMC object to estimate the marginal likelihood
using Nested Sampling.}
\usage{
create_ns_mcmc(
  chain_length = 1e+07,
  store_every = -1,
  pre_burnin = 0,
  n_init_attempts = 3,
  particle_count = 1,
  sub_chain_length = 5000,
  epsilon = "1e-12",
  tracelog = beautier::create_tracelog(),
  screenlog = beautier::create_screenlog(),
  treelog = beautier::create_treelog()
)
}
\arguments{
\item{chain_length}{upper bound to the length of the MCMC chain}

\item{store_every}{number of states the MCMC will process
before the posterior's state will be saved to file.
Use -1 or \code{NA} to use the default frequency.}

\item{pre_burnin}{number of burn in samples taken before entering
the main loop}

\item{n_init_attempts}{number of initialization attempts before failing}

\item{particle_count}{number of particles}

\item{sub_chain_length}{sub-chain length}

\item{epsilon}{epsilon}

\item{tracelog}{a \code{tracelog},
as created by \link{create_tracelog}}

\item{screenlog}{a \code{screenlog},
as created by \link{create_screenlog}}

\item{treelog}{a \code{treelog},
as created by \link{create_treelog}}
}
\value{
an MCMC object
}
\description{
This will result in a BEAST run that estimates the marginal
likelihood until convergence is achieved.
In this context, \code{chain_length} is only an upper bound
to the length of that run.
}
\examples{
check_empty_beautier_folder()

mcmc <- create_ns_mcmc(
  chain_length = 1e7,
  store_every = 1000,
  particle_count = 1,
  sub_chain_length = 1000,
  epsilon = 1e-12
)

beast2_input_file <- get_beautier_tempfilename()
create_beast2_input_file(
  get_fasta_filename(),
  beast2_input_file,
  mcmc = mcmc
)
file.remove(beast2_input_file)

remove_beautier_folder()
check_empty_beautier_folder()
}
\references{
* [1] Patricio Maturana Russel, Brendon J Brewer, Steffen Klaere,
    Remco R Bouckaert; Model Selection and Parameter Inference in
    Phylogenetics Using Nested Sampling, Systematic Biology, 2018,
    syy050, https://doi.org/10.1093/sysbio/syy050
}
\seealso{
Use \code{\link{create_mcmc}} to create a regular MCMC.
Use \code{\link{create_test_ns_mcmc}} to create an NS MCMC for testing,
  with, among others, a short MCMC chain length.
Use \code{\link{check_ns_mcmc}} to check that an NS MCMC object is valid.
}
\author{
Richèl J.C. Bilderbeek
}
