% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_mrca_prior.R
\name{has_mrca_prior}
\alias{has_mrca_prior}
\title{Determines if the inference model has an MRCA prior.}
\usage{
has_mrca_prior(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
TRUE if the inference model has an MRCA prior,
  FALSE otherwise
}
\description{
Will \link{stop} if the inference model is invalid
}
\note{
MRCA: 'Most Recent Common Ancestor'
}
\examples{
check_empty_beautier_folder()

# No MRCA prior
inference_model <- create_inference_model(
  mrca_prior = NA
)
has_mrca_prior(inference_model) # Returns FALSE

# A default MRCA prior
inference_model <- create_inference_model(
  mrca_prior = create_mrca_prior()
)
has_mrca_prior(inference_model) # Returns TRUE

check_empty_beautier_folder()
}
\seealso{
\itemize{
    \item \code{\link{create_inference_model}}: create an inference model
    \item \code{\link{create_mrca_prior}}: create an MRCA prior
  }
}
\author{
Richèl J.C. Bilderbeek
}
