% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_empty_beautier_folder.R
\name{check_empty_beautier_folder}
\alias{check_empty_beautier_folder}
\title{Internal function}
\usage{
check_empty_beautier_folder(beautier_folder = get_beautier_folder())
}
\arguments{
\item{beautier_folder}{the path to
the \link{beautier} temporary files folder}
}
\value{
Nothing.
}
\description{
Internal function to verify that, if there are `beautier`
temporary files created, these are also cleaned up,
as by CRAN policy.
}
\details{
If the `beautier` folder does not exist, this function
does nothing.
If there are folder and/or files in the `beautier` folder,
an error is given.
}
\examples{
remove_beautier_folder()

check_empty_beautier_folder()

remove_beautier_folder()
}
\seealso{
use \link{remove_beautier_folder} to remove the default
`beautier` folder
}
\author{
Richèl J.C. Bilderbeek
}
