% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colPointsLegend.R
\name{colPointsLegend}
\alias{colPointsLegend}
\title{Legend for colPoints}
\usage{
colPointsLegend(z, Range = range(z, finite = TRUE), nbins = 100,
  colors = seqPal(nbins), bb = seqR(Range, length.out = nbins + 1),
  at = pretty2(Range), labels = at, adj = 0.5, x1 = 0.6, y1 = 0.88,
  x2 = 0.99, y2 = 0.99, outer = FALSE, xpd = NA, mar, mgp = c(1.8,
  0.6, 0), bg = "white", sborder = NA, resetfocus = TRUE,
  plottriangle = FALSE, triangle = 0.14, tricol = c(8, 1),
  density = NULL, lines = TRUE, atminmax = FALSE, horizontal = TRUE,
  labelpos = 1, titlepos = 3, title = "Legend", las = 1, x, y, index,
  ...)
}
\arguments{
\item{z}{Values of third dimension used in \code{\link{colPoints}}, 
can be a matrix or a vector etc, but must be numeric}

\item{Range}{Ends of color bar for method=equalinterval. DEFAULT: range(z, finite=TRUE)}

\item{nbins}{Number of classes (thus, colors). If \code{colors} is given, 
\code{nbins} is overwritten with \code{length(colors)}. DEFAULT: 100}

\item{colors}{Color vector. DEFAULT: \code{\link{seqPal}} 
from yellow (lowest) to blue (highest value in Range)}

\item{bb}{Borders of bins for the legend (key). DEFAULT: seqR(Range, length.out=nbins+1)}

\item{at}{Positions of legend labels. DEFAULT: pretty2(Range)}

\item{labels}{Labels that are written at the positions of \code{at}. DEFAULT: at}

\item{adj}{label adjustment parallel to legend bar (only one number!). DEFAULT: 0.5}

\item{x1, x2, y1, y2}{Relative coordinates [0:1] of inset plot, see \code{\link{smallPlot}}. 
DEFAULT: x: 0.6-0.99, y: 0.88-0.99}

\item{outer}{Logical: Should legend be relative to device instead of current figure?
use outer=TRUE when par(mfrow, oma) is set. DEFAULT: FALSE}

\item{xpd}{Logical: should text be expanded outisde of plotting region?
Must be NA if outer=TRUE. DEFAULT: NA}

\item{mar}{Margins for \code{\link{smallPlot}}. 
DEFAULT: internal calculations based on title, labelpos and titlepos.}

\item{mgp}{MarGinPlacement: distance of xlab/ylab, numbers and line from plot margin, 
as in \code{\link{par}}, but with different defaults. DEFAULT: c(1.8, 0.6, 0)}

\item{bg}{Background behind key, labels and title. DEFAULT: "white"}

\item{sborder}{Border around inset subplot. DEFAULT: NA}

\item{resetfocus}{Reset focus to original plot? 
Specifies where further low level plot commands are directed to. DEFAULT: TRUE}

\item{plottriangle}{Should triangles be plotted at the end of the legend for values outside Range? 
Vector of length two (for lower and upper, internally recycled). 
If this argument is missing but triangle is given, this is set to TRUE. DEFAULT: FALSE}

\item{triangle}{Percentage of bar length at lower and upper end for triangles 
(can be a vector with two different values). DEFAULT: 0.14}

\item{tricol}{Triangle colors for lower and upper end. DEFAULT: c(8,1)}

\item{density}{List of arguments passed to \code{kernel \link{density} estimation}. 
Can also be FALSE to suppress KDE line drawing. DEFAULT: NULL}

\item{lines}{Plot black lines in the color bar at \code{at}? DEFAULT: TRUE}

\item{atminmax}{Should the extrema of the legend be added to \code{at}? DEFAULT: FALSE}

\item{horizontal}{Horizontal bar? if FALSE, a vertical bar is drawn. DEFAULT: TRUE}

\item{labelpos}{Position of labels relative to the bar. 
Possible: 1 (below), 2 (left), 3 (above), 4 (right), 5(on top of bar). DEFAULT: 1}

\item{titlepos}{Position of title -"-. DEFAULT: 3}

\item{title}{Legend title. DEFAULT: "Legend"}

\item{las}{LabelAxisStyle. DEFAULT: 1}

\item{x, y, index}{Ignored arguments, so that you can pass the result from 
\code{\link{colPoints}} via \code{do.call(colPointsLegend, cp_result)}}

\item{\dots}{Further arguments passed to \code{\link{text}} and \code{\link{strwidth}}, 
e.g. cex, srt, font, col. But NOT adj!}
}
\value{
invisible list of par of \code{\link{smallPlot}}, adds legend bar to current plot
}
\description{
Adds legends to plots created or enhanced with \code{\link{colPoints}}
}
\note{
\code{x1,x2,y1,y2,labelpos,titlepos,title} have different defaults when \code{horizontal=FALSE}
}
\examples{

z <- rnorm(50)
plot(1:10)
colPointsLegend(z=z)
colPointsLegend(z=z, titlepos=2)
colPointsLegend(z=z, horiz=FALSE) # note the different defaults
# positioning relative to plot:
colPointsLegend(z=z, x1=0.05, x2=0.3, y1=0.7,y2=0.9, title="Booh!", density=FALSE)
# Denote values outside of Range wit a triangle:
colPointsLegend(z=z, Range=c(-1,3), x1=0.2, y1=0.4, y2=0.6, triangle=0.2)
colPointsLegend(z=z, horiz=FALSE, x1=0.7, y1=0.6, plottriangle=TRUE, density=FALSE)
?colPoints # example section for actual usage

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, 2012-2014
}
\seealso{
\code{\link{colPointsHist}}, \code{\link{colPoints}} for real life example
}
\keyword{aplot}
\keyword{color}

