% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locatorRS.R
\name{locatorRS}
\alias{locatorRS}
\title{locator with immediate points in Rstudio}
\usage{
locatorRS(n = 512, type = "p", ...)
}
\arguments{
\item{n}{Maximum number of points to plot.}

\item{type}{As in \code{\link{locator}}, but passed to \code{\link{points}}. 
DEFAULT: "p"}

\item{\dots}{Further arguments passed to \code{\link{points}}}
}
\value{
List with x and y
}
\description{
Have \code{\link{locator}} add points on the graph directly after clicking, even in Rstudio Graphics devices
}
\examples{
if(interactive()){
plot(1:10, type="n")
locs <- locator(n=3, type="o") # click on locations in graph. 
# If you do not set n at beginning, press ESC to finish
locs
# In Rstudio, points only appear after finishing.
locatorRS(7, col="blue", type="o") # plots after each click
}

}
\seealso{
\url{https://stackoverflow.com/q/65147219/1587132}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Dec 2020
}
\keyword{aplot}
