% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx2.R
\name{approx2}
\alias{approx2}
\title{Smart linear NA interpolation}
\usage{
approx2(x, fill = NULL, n = length(x), quiet = FALSE, ...)
}
\arguments{
\item{x}{Vector with (numeric) values}

\item{fill}{Function to fill NAs at the start or end of the vector. See Details. DEFAULT: NULL}

\item{n}{Number of points to interpolate to}

\item{quiet}{Logical: suppress warning for no non-NA values? DEFAULT: FALSE}

\item{\dots}{Further arguments passed to \code{\link{approx}}}
}
\value{
Vector with NAs replaced with interpolation (not a list, as in \code{\link{approx}}!)
}
\description{
Smart interpolation: as \code{\link{approx}}, approx2 fills NAs in a vector with linear interpolation,
but unlike \code{\link{approx}}, it can handle NAs at the ends of a vector
(takes the first/last value available for those). Also, approx2 returns a vector only.
}
\details{
The function fill is used to fill missing values at the ends of the vector.
It could be mean or median, for example, but must be a function that accepts \code{na.rm=TRUE} as an argument.
The default (NULL) means to use the first (or last) observation available.
}
\examples{

approx2(c(NA,NA))   # yields a message
approx2(c(NA,NA, 6, 4, 8, 9, 3, 2, 1)) # fills with first non-NA value
approx2(c( 2,NA, 6, 4, 8, 9, 3, 2, 1)) # interpolates linearly
approx2(c( 2, 4, 6, 4, 8, 9,NA, 2,NA)) # linear, then last non-NA at end

approx2(c(NA,NA, 6, 4, 8, 9, 3, 2, 1))
approx2(c(NA,NA, 6, 4, 8, 9, 3, 2, 1), fill=median) # first median, then linear
approx2(c(NA,NA, 6, 4, 8, 9, 3, 2, 1), fill=mean)

approx2(c( 3, 4, 6, 4, 8, 9,NA, 2,NA))
approx2(c( 3, 4, 6, 4, 8, 9,NA, 2,NA), fill=median)
approx2(c( 3, 4, 6, 4, 8, 9,NA, 2,NA), fill=mean)

approx2(c(NA,NA, 6, 4, 8, 9, 3, 2, 1), n=17)
approx2(c( 2,NA, 6, 4, 8, 9, 3, 2, 1), n=17)
approx2(c( 2, 4, 6, 4, 8, 9,NA, 2,NA), n=17)

}
\seealso{
\code{\link{approx}}, zoo::na.locf, \code{\link{ciBand}} for usage example
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, July 2015
}
\keyword{arith}
\keyword{dplot}
