% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderNorm.R
\name{orderNorm}
\alias{orderNorm}
\alias{predict.orderNorm}
\alias{predict.orderNorm}
\alias{print.orderNorm}
\title{Calculate and perform Ordered Quantile normalizing transformation}
\usage{
orderNorm(x)

\method{predict}{orderNorm}(object, newdata = NULL, inverse = FALSE, ...)

\method{print}{orderNorm}(x, ...)
}
\arguments{
\item{x}{A vector to normalize}

\item{object}{an object of class 'orderNorm'}

\item{newdata}{a vector of data to be (reverse) transformed}

\item{inverse}{if TRUE, performs reverse transformation}

\item{...}{additional arguments}
}
\value{
A list of class \code{orderNorm} with elements
  
\item{x.t}{transformed original data} 
\item{x}{original data} 
\item{n}{number of nonmissing observations}
\item{warn_status}{indicator if ties are present}
\item{fit}{fit to be used for extrapolation, if needed}
\item{norm_stat}{Pearson's P / degrees of freedom}
The \code{predict} function returns the numeric value of the transformation 
performed on new data, and allows for the inverse transformation as well.
}
\description{
The Ordered Quantile normalization transformation,
  \code{orderNorm()}, is a rank-based procedure by which the values of a
  vector are mapped to their percentile, which is then mapped to the same
  percentile of the normal distribution. Without the presence of ties, this
  essentially guarantees that the transformation leads to a uniform
  distribution.

  The transformation is: \deqn{g(x) = \Phi ^ {-1} (rank(x) / (length(x) +
  1))}

  Where \eqn{\Phi} refers to the standard normal cdf, rank(x) refers to each
  observation's rank, and length(x) refers to the number of observations.

  Using linear interpolation between these percentiles, the orderNorm becomes
  a 1-1 transformation. While it is possible to extrapolate beyond the
  observed values, a warning will occur. This is because outside of the
  observed domain of x, it is unclear how to extrapolate the transformation.
  A linear approximation lm(g(x) ~ x) is used to extrapolate beyond the
  original domain.

  This transformation can be performed on new data and inverted via the
  \code{predict} function.
}
\examples{

x <- rgamma(100, 1, 1)

orderNorm_obj <- orderNorm(x)
orderNorm_obj
p <- predict(orderNorm_obj)
x2 <- predict(orderNorm_obj, newdata = p, inverse = TRUE)

all.equal(x2, x)

}
\seealso{
\code{\link{boxcox}},
 \code{\link{lambert}}, 
 \code{\link{bestNormalize}},
 \code{\link{yeojohnson}}
}
