% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-diff-beta-nb.R
\name{DiffBetaNB}
\alias{DiffBetaNB}
\title{Estimate Differences of Standardized Slopes
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping}
\usage{
DiffBetaNB(object, alpha = c(0.05, 0.01, 0.001))
}
\arguments{
\item{object}{Object of class \code{nb}, that is,
the output of the \code{NB()} function.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.}
}
\value{
Returns an object
of class \code{betanb} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{thetahatstar}{Sampling distribution of
differences of standardized regression slopes.}
\item{vcov}{Sampling variance-covariance matrix of
differences of standardized regression slopes.}
\item{est}{Vector of estimated
differences of standardized regression slopes.}
\item{fun}{Function used ("DiffBetaNB").}
}
}
\description{
Estimate Differences of Standardized Slopes
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping
}
\details{
The vector of differences of standardized regression slopes
is estimated from bootstrap samples.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of differences of standardized regression slopes,
where \eqn{\alpha} is the significance level.
}
\examples{
# Data ---------------------------------------------------------------------
data("nas1982", package = "betaNB")

# Fit Model in lm ----------------------------------------------------------
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)

# NB -----------------------------------------------------------------------
nb <- NB(
  object,
  R = 100, # use a large value e.g., 5000L for actual research
  seed = 0508
)

# DiffBetaNB ---------------------------------------------------------------
out <- DiffBetaNB(nb, alpha = 0.05)

## Methods -----------------------------------------------------------------
print(out)
summary(out)
coef(out)
vcov(out)
confint(out, level = 0.95)

}
\seealso{
Other Beta Nonparametric Bootstrap Functions: 
\code{\link{BetaNB}()},
\code{\link{DeltaRSqNB}()},
\code{\link{NB}()},
\code{\link{PCorNB}()},
\code{\link{RSqNB}()},
\code{\link{SCorNB}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Nonparametric Bootstrap Functions}
\keyword{betaNB}
\keyword{diff}
